/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.compressions.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.ReadableByteChannel;
import org.simantics.compressions.impl.Channels;

public abstract class DecompressingInputStream
extends InputStream {
    protected InputStream stream;
    protected ReadableByteChannel channel;
    protected ByteBuffer header;
    protected IntBuffer intHeader;
    protected ByteBuffer compressed;
    protected ByteBuffer uncompressed;
    protected byte[] compressedArray;

    public DecompressingInputStream(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public DecompressingInputStream(FileInputStream stream) {
        this(stream, stream.getChannel());
    }

    public DecompressingInputStream(InputStream stream) {
        this(stream, null);
    }

    public DecompressingInputStream(InputStream stream, ReadableByteChannel channel) {
        this.stream = stream;
        this.channel = channel;
        this.header = ByteBuffer.allocate(8);
        this.header.order(ByteOrder.LITTLE_ENDIAN);
        this.intHeader = this.header.asIntBuffer();
    }

    @Override
    public int read() throws IOException {
        if (!(this.uncompressed != null && this.uncompressed.remaining() != 0 || this.fillBuffer())) {
            return -1;
        }
        return this.uncompressed.get();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytes = 0;
        while (len > 0) {
            if (!(this.uncompressed != null && this.uncompressed.remaining() != 0 || this.fillBuffer())) {
                return bytes == 0 ? -1 : bytes;
            }
            int s = Math.min(len, this.uncompressed.remaining());
            this.uncompressed.get(b, off, s);
            off += s;
            len -= s;
            bytes += s;
        }
        return bytes;
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    private boolean fillBuffer() throws IOException {
        this.header.position(0);
        if (this.channel != null ? Channels.read(this.channel, this.header) < 8 : Channels.readStream(this.stream, this.header.array(), 8) < 8) {
            return false;
        }
        this.intHeader.position(0);
        int compressedSize = this.intHeader.get();
        int uncompressedSize = this.intHeader.get();
        if (uncompressedSize == 0) {
            return false;
        }
        this.uncompressed = this.ensureBufferSize(this.uncompressed, uncompressedSize);
        this.compressed = this.ensureBufferSize(this.compressed, compressedSize);
        this.compressed.position(0);
        this.compressed.limit(compressedSize);
        if (this.channel != null) {
            if (Channels.read(this.channel, this.compressed) < compressedSize) {
                return false;
            }
        } else {
            if (this.compressedArray == null || this.compressedArray.length < compressedSize) {
                this.compressedArray = new byte[compressedSize];
            }
            if (Channels.readStream(this.stream, this.compressedArray, compressedSize) < 8) {
                return false;
            }
            this.compressed.put(this.compressedArray, 0, compressedSize);
        }
        this.decompress(this.compressed, 0, compressedSize, this.uncompressed, 0, uncompressedSize);
        this.uncompressed.position(0);
        this.uncompressed.limit(uncompressedSize);
        return true;
    }

    private ByteBuffer ensureBufferSize(ByteBuffer buffer, int minCapacity) {
        int oldCapacity;
        int n = oldCapacity = buffer != null ? buffer.capacity() : 0;
        if (buffer == null || oldCapacity < minCapacity) {
            int newCapacity = DecompressingInputStream.grow(oldCapacity, minCapacity);
            buffer = this.allocateBuffer(newCapacity);
        }
        return buffer;
    }

    protected ByteBuffer allocateBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity);
    }

    private static int grow(int oldCapacity, int minCapacity) {
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return newCapacity;
    }

    public abstract void decompress(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6) throws IOException;
}

