/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common;

import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.procedure.AsyncProcedure;

public final class ProcedureBarrier<T>
extends AtomicInteger {
    private static final long serialVersionUID = -2699547741948233067L;
    private volatile Throwable throwable;

    public ProcedureBarrier(int initial) {
        super(initial);
    }

    public final synchronized void except(Throwable throwable) {
        this.throwable = throwable;
    }

    public final Throwable getThrowable() {
        return this.throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dec(AsyncReadGraph graph, AsyncProcedure<T> procedure, Throwable throwable) {
        ProcedureBarrier procedureBarrier = this;
        synchronized (procedureBarrier) {
            this.throwable = throwable;
        }
        if (this.decrementAndGet() == 0) {
            procedure.exception(graph, throwable);
        }
    }

    public final void dec(AsyncReadGraph graph, AsyncProcedure<T> procedure, T result) {
        if (this.decrementAndGet() == 0) {
            if (this.throwable != null) {
                procedure.exception(graph, this.throwable);
            } else {
                procedure.execute(graph, result);
            }
        }
    }
}

