/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt.widgets;

import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.datastructures.Triple;

public class StringPropertyFactory
extends ReadFactoryImpl<Resource, String> {
    private final String propertyURI;
    private final String defaultValue;

    public StringPropertyFactory(String propertyURI) {
        this(propertyURI, null);
    }

    public StringPropertyFactory(String propertyURI, String defaultValue) {
        this.propertyURI = propertyURI;
        this.defaultValue = defaultValue;
    }

    @Override
    public Object getIdentity(Object inputContents) {
        return new Triple((Object)((Resource)inputContents), (Object)this.propertyURI, this.getClass());
    }

    @Override
    public String perform(ReadGraph graph, Resource resource) throws DatabaseException {
        String value = (String)graph.getPossibleRelatedValue(resource, graph.getResource(this.propertyURI));
        return value != null ? value : this.defaultValue;
    }
}

