/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.CheckedState;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.NodeQueryProcessor;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.common.EvaluatorData;
import org.simantics.browsing.ui.common.Preference;
import org.simantics.browsing.ui.content.CheckedStateFactory;
import org.simantics.utils.datastructures.collections.CollectionUtils;

public class DefaultIsCheckedProcessor2
implements NodeQueryProcessor<CheckedState> {
    private final EvaluatorData data;

    public DefaultIsCheckedProcessor2(EvaluatorData data) {
        this.data = data;
    }

    public NodeContext.QueryKey<CheckedState> getIdentifier() {
        return BuiltinKeys.IS_CHECKED;
    }

    public CheckedState query(NodeQueryManager manager, NodeContext context) {
        assert (context != null);
        Object input = context.getConstant(BuiltinKeys.INPUT);
        assert (input != null);
        Collection evals = this.data.get(input);
        if (evals.isEmpty()) {
            return null;
        }
        ArrayList<Preference<CheckedStateFactory>> factories = new ArrayList<Preference<CheckedStateFactory>>(4);
        for (EvaluatorData.Evaluator eval : evals) {
            this.evaluateTree(manager, context, (EvaluatorData.EvaluatorTree<CheckedStateFactory>)eval.getCheckStateTree(), factories);
        }
        if (factories.isEmpty()) {
            return null;
        }
        if (factories.size() >= 1) {
            Collections.sort(factories);
            return (CheckedState)manager.query(context, (NodeContext.PrimitiveQueryKey)new BuiltinKeys.CheckedStateKey((CheckedStateFactory)factories.get((int)0).object));
        }
        return null;
    }

    protected void evaluateTree(NodeQueryManager manager, NodeContext context, EvaluatorData.EvaluatorTree<CheckedStateFactory> tree, Collection<Preference<CheckedStateFactory>> result) {
        Tester test = tree.getTester();
        if (test.test(manager, context)) {
            CollectionUtils.checkedAdd((Collection)tree.getAcceptedFactories(), result);
            Collection children = tree.getChildren();
            if (children == null) {
                return;
            }
            for (EvaluatorData.EvaluatorTree e : children) {
                this.evaluateTree(manager, context, (EvaluatorData.EvaluatorTree<CheckedStateFactory>)e, result);
            }
        }
    }

    public String toString() {
        return "IsCheckedProcessor";
    }
}

