/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClusterStream;
import fi.vtt.simantics.procore.internal.ClusterTable;
import fi.vtt.simantics.procore.internal.ClusterTranslatorImpl;
import fi.vtt.simantics.procore.internal.GraphSessionSocket;
import fi.vtt.simantics.procore.internal.QuerySupportImpl;
import fi.vtt.simantics.procore.internal.ResourceSupportImpl;
import fi.vtt.simantics.procore.internal.SerialisationSupportImpl;
import fi.vtt.simantics.procore.internal.ServerInformationImpl;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.SessionRequestManager;
import fi.vtt.simantics.procore.internal.StaticSessionProperties;
import fi.vtt.simantics.procore.internal.WriteSupportImpl;
import java.io.File;
import java.util.Set;
import org.simantics.db.Database;
import org.simantics.db.SessionManager;
import org.simantics.db.SessionReference;
import org.simantics.db.VirtualGraph;
import org.simantics.db.authentication.UserAuthenticationAgent;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InvalidAuthenticationException;
import org.simantics.db.exception.InvalidUserException;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTranslator;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.graph.WriteSupport;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.service.ServerInformation;

public final class SessionImplDb
extends SessionImplSocket {
    protected ServerInformationImpl serverInfo;

    public SessionImplDb(SessionManager sessionManager, UserAuthenticationAgent authAgent) {
        super(sessionManager, authAgent);
    }

    @Override
    protected VirtualGraph getProvider(VirtualGraph vg) {
        return vg;
    }

    @Override
    public ResourceImpl getNewResource() throws DatabaseException {
        int newId;
        if (this.defaultClusterSet != null) {
            return this.getNewResource(this.defaultClusterSet);
        }
        ClusterImpl cluster = this.getNewResourceCluster();
        try {
            newId = cluster.createResource((ClusterSupport)this.clusterTranslator);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
        return new ResourceImpl((ResourceSupport)this.resourceSupport, newId);
    }

    public void connect(SessionReference sessionReference, Database.Session dbSession) throws Exception {
        if (this.clusterTable == null) {
            File t = StaticSessionProperties.virtualGraphStoragePath;
            if (t == null) {
                t = new File(".");
            }
            this.clusterTable = new ClusterTable(this, t);
        }
        this.graphSession = new GraphSessionSocket(this, sessionReference, dbSession);
        try {
            this.clusterStream = new ClusterStream(this, this.graphSession, false);
            this.clusterTranslator = new ClusterTranslatorImpl(this);
            this.serviceLocator.registerService(ClusterTranslator.class, this.clusterTranslator);
            this.serviceLocator.registerService(ClusterSupport.class, this.clusterTranslator);
            this.resourceSupport = new ResourceSupportImpl(this);
            this.requestManager = new SessionRequestManager(this, this.state);
            this.querySupport = new QuerySupportImpl(this, (ClusterSupport)this.clusterTranslator, new SerialisationSupportImpl(this), this.requestManager);
            this.serviceLocator.registerService(QuerySupport.class, this.querySupport);
            this.queryProvider2 = new QueryProcessor(this.getAmountOfQueryThreads(), (QuerySupport)this.querySupport, (Set)this.sessionThreads);
            this.writeSupport = new WriteSupportImpl(this);
            this.serviceLocator.registerService(WriteSupport.class, this.writeSupport);
            this.state.setGraphSession(this, this.graphSession, this.queryProvider2, this.clusterTable);
            this.serverInfo = this.graphSession.getServerInformation();
        }
        catch (InvalidAuthenticationException e) {
            throw e;
        }
        catch (InvalidUserException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            Logger.defaultLogError((String)"Unhandled error. See exception for details.", (Throwable)e);
            this.graphSession = null;
            this.clusterTable.dispose();
            this.clusterTable = null;
            throw new Exception(e);
        }
        String databaseId = this.serverInfo.getDatabaseId();
        String serverId = this.serverInfo.getServerId();
        this.virtualGraphServerSupport.connect(String.valueOf(databaseId) + "." + serverId);
        this.clusterSetsSupport.connect(String.valueOf(databaseId) + "." + serverId);
    }

    @Override
    protected ServerInformation getCachedServerInformation() {
        return this.serverInfo;
    }
}

