/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.SessionImplSocket;
import java.util.Collection;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.procedure.AsyncContextMultiProcedure;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.Write;
import org.simantics.db.service.QueryControl;
import org.simantics.utils.DataContainer;

public class QueryControlImpl
implements QueryControl {
    private final SessionImplSocket session;

    QueryControlImpl(SessionImplSocket session) {
        this.session = session;
    }

    public int getAmountOfQueryThreads() {
        return this.session.getAmountOfQueryThreads();
    }

    public int getGraphThread(AsyncReadGraph graph) {
        return 0;
    }

    public int flush() {
        final DataContainer result = new DataContainer();
        try {
            this.session.syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    result.set((Object)((QueryControlImpl)QueryControlImpl.this).session.queryProvider2.clean());
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return (Integer)result.get();
    }

    public int flush(ReadGraph graph) {
        return this.session.queryProvider2.clean();
    }

    public int count() {
        return this.session.queryProvider2.querySize();
    }

    public void gc(ReadGraph graph, int allowedTimeInMs) {
        this.session.queryProvider2.gc(20, allowedTimeInMs);
    }

    public void gc(final Collection<ExternalRead<?>> requests) {
        try {
            this.session.syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    QueryControlImpl.this.gc(graph, requests);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public void gc(WriteGraph graph, Collection<ExternalRead<?>> requests) {
        if (graph == null) {
            throw new IllegalArgumentException("null WriteGraph");
        }
        if (requests == null) {
            throw new IllegalArgumentException("null requests");
        }
        this.session.queryProvider2.clean(requests);
    }

    public boolean scheduleByCluster(AsyncReadGraph graph, Resource resource, AsyncMultiProcedure<Resource> procedure) {
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        ResourceImpl res = (ResourceImpl)resource;
        int targetThread = res.id >>> 16 & this.session.queryProvider2.THREAD_MASK;
        if (targetThread == 0) {
            return true;
        }
        procedure.execute((AsyncReadGraph)impl, (Object)resource);
        return false;
    }

    public <C> boolean scheduleByCluster(AsyncReadGraph graph, Resource resource, C context, AsyncContextMultiProcedure<C, Resource> procedure) {
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        ResourceImpl res = (ResourceImpl)resource;
        int targetThread = res.id >>> 16 & this.session.queryProvider2.THREAD_MASK;
        if (targetThread == 0) {
            return true;
        }
        procedure.execute((AsyncReadGraph)impl, context, (Object)resource);
        return false;
    }

    public void schedule(AsyncReadGraph graph, int targetThread, QueryControl.ControlProcedure procedure) {
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        procedure.execute((AsyncReadGraph)impl);
    }

    public ReadGraph getIndependentGraph(ReadGraph graph) {
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        return impl.withParent(null);
    }

    public boolean hasParentRequest(ReadGraph graph) {
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        return impl.parent != null;
    }

    public boolean resume(AsyncReadGraph graph) {
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        return impl.processor.querySupport.resume(impl);
    }
}

