/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClusterChange;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.LinkedList;

public class ClusterChangeManager {
    private final THashSet<ClusterChange> clusterChanges = new THashSet();
    private final LinkedList<ClusterChange> removeList = new LinkedList();
    private int changeCounter = 0;
    private int byteLimit = 65536;

    public void checkFlush() {
        if (this.changeCounter < 50) {
            return;
        }
        ClusterChange test = this.removeList.poll();
        if (test == null) {
            return;
        }
        if (test.byteIndex > this.byteLimit) {
            test.flushCollect(null);
        } else {
            this.removeList.add(test);
        }
    }

    public void updateChangeCounters() {
        this.changeCounter = this.clusterChanges.size();
        this.byteLimit = (100 - this.changeCounter) * 49152;
    }

    void addChange(ClusterChange change) {
        this.clusterChanges.add((Object)change);
        this.updateChangeCounters();
    }

    Collection<ClusterChange> get() {
        return this.clusterChanges;
    }

    void add(ClusterChange change) {
        if (this.clusterChanges.add((Object)change)) {
            this.removeList.add(change);
        } else {
            new Exception("trying to add change that already exists").printStackTrace();
        }
        this.updateChangeCounters();
    }

    void remove(Collection<ClusterChange> changes) {
        this.clusterChanges.removeAll(changes);
        this.removeList.removeAll(changes);
        this.updateChangeCounters();
    }

    int size() {
        return this.clusterChanges.size();
    }

    void clear() {
        this.clusterChanges.clear();
        this.removeList.clear();
        this.updateChangeCounters();
    }
}

