/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.modules;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.properties.widgets.modules.ReferenceRow;
import org.simantics.ui.SimanticsUI;

public class ModuleInputEditingSupport
extends EditingSupport {
    private CellEditor editor;
    private int column;
    private HashMap<String, Resource> optionResources;
    private String[] options;
    private TableViewer tableViewer;

    public ModuleInputEditingSupport(TableViewer viewer, int column) {
        super((ColumnViewer)viewer);
        this.tableViewer = viewer;
        this.column = column;
    }

    protected boolean canEdit(Object element) {
        switch (this.column) {
            case 0: {
                return false;
            }
        }
        return true;
    }

    protected CellEditor getCellEditor(Object element) {
        switch (this.column) {
            case 0: {
                this.editor = new TextCellEditor((Composite)this.tableViewer.getTable());
            }
            case 1: {
                ReferenceRow row = (ReferenceRow)element;
                final Resource module = row.getModule();
                final Resource inputVariable = row.getVariable();
                this.optionResources = new HashMap();
                try {
                    this.optionResources = (HashMap)SimanticsUI.getSession().syncRequest((Read)new Read<HashMap<String, Resource>>(){

                        public HashMap<String, Resource> perform(ReadGraph graph) throws DatabaseException {
                            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                            HashMap<String, Resource> result = new HashMap<String, Resource>();
                            for (Resource dependency : (Collection)graph.syncRequest((Read)new ObjectsWithType(module, sr.Variable_isHeadOf, sr.Dependency))) {
                                if (graph.getPossibleObject(dependency, sr.Dependency_refersTo) != null && !graph.getPossibleObject(dependency, sr.Dependency_refersTo).equals(inputVariable)) continue;
                                Resource output = graph.getSingleObject(dependency, sr.Variable_HasTail);
                                if (graph.isInstanceOf(output, sr.Shadow)) {
                                    output = graph.getPossibleObject(output, sr.Shadow_original);
                                }
                                if (output == null) continue;
                                result.put((String)graph.getRelatedValue(output, l0.HasName), dependency);
                            }
                            return result;
                        }
                    });
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
                this.options = this.optionResources.keySet().toArray(new String[this.optionResources.keySet().size() + 1]);
                this.options[this.optionResources.keySet().size()] = "";
                ComboBoxCellEditor ceditor = new ComboBoxCellEditor((Composite)this.tableViewer.getTable(), this.options, 8);
                ceditor.setActivationStyle(1);
                this.editor = ceditor;
                break;
            }
            default: {
                this.editor = null;
            }
        }
        return this.editor;
    }

    protected Object getValue(Object element) {
        ReferenceRow referenceRow = (ReferenceRow)element;
        switch (this.column) {
            case 0: {
                return referenceRow.getName();
            }
            case 1: {
                String refersToName = referenceRow.getValue();
                if (refersToName == null) {
                    return this.options.length - 1;
                }
                int i = 0;
                while (i < this.options.length) {
                    if (refersToName.equals(this.options[i])) {
                        return i;
                    }
                    ++i;
                }
                return this.options[this.options.length - 1];
            }
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        ReferenceRow referenceRow = (ReferenceRow)element;
        String valueString = String.valueOf(value);
        switch (this.column) {
            case 0: {
                break;
            }
            case 1: {
                referenceRow.setRefersTo(this.optionResources.get(this.options[Integer.parseInt(valueString)]));
                break;
            }
        }
        this.getViewer().update(element, null);
    }
}

