/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.userComponent;

import gnu.trove.map.hash.THashMap;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;

public class TypeConversion {
    private static final THashMap<String, Datatype> CONVERSION_MAP = new THashMap();

    static {
        TypeConversion.add("Boolean", (Datatype)Datatypes.BOOLEAN);
        TypeConversion.add("Integer", (Datatype)Datatypes.INTEGER);
        TypeConversion.add("Long", (Datatype)Datatypes.LONG);
        TypeConversion.add("Float", (Datatype)Datatypes.FLOAT);
        TypeConversion.add("Double", (Datatype)Datatypes.DOUBLE);
        TypeConversion.add("String", (Datatype)Datatypes.STRING);
    }

    private static void add(String sclType, Datatype dataType) {
        CONVERSION_MAP.put((Object)sclType, (Object)dataType);
        CONVERSION_MAP.put((Object)("[" + sclType + "]"), (Object)new ArrayType(dataType));
        CONVERSION_MAP.put((Object)("Array " + sclType), (Object)new ArrayType(dataType));
        CONVERSION_MAP.put((Object)("Vector " + sclType), (Object)new ArrayType(dataType));
    }

    public static Datatype convertSCLTypeToDatatype(String type) {
        return (Datatype)CONVERSION_MAP.get((Object)type);
    }
}

