/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.migration;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.migration.MigrationStep;
import org.simantics.db.layer0.migration.MigrationUtils;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.WriteInterface;
import org.simantics.document.DocumentResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingUtils;

public class DocumentCleanupMigrationStep
implements MigrationStep {
    public void applyTo(IProgressMonitor monitor, Session session, MigrationState state) throws DatabaseException {
        final Resource indexRoot = MigrationUtils.getResource((IProgressMonitor)monitor, (Session)session, (MigrationState)state);
        if (indexRoot == null) {
            return;
        }
        session.sync((WriteInterface)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
                for (Resource model : graph.getObjects(indexRoot, L0.ConsistsOf)) {
                    for (Resource instance : ModelingUtils.searchByType((ReadGraph)graph, model, DOC.ScenegraphDocument)) {
                        if (graph.hasStatement(instance, DOC.HasDocumentation_Inverse)) continue;
                        System.err.println("Removing stray document " + graph.getURI(instance));
                        RemoverUtil.remove((WriteGraph)graph, (Resource)instance);
                    }
                }
            }
        });
    }
}

