/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.views;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.Bean;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.views.ontology.ViewsResources;

public class ViewUtils {
    public static final Binding EXTENDED_MARGINS_BINDING = Bindings.getBindingUnchecked(ExtendedMargins.class);

    public static GridLayoutBean getLayout(RequestProcessor processor, Resource configuration) throws DatabaseException {
        return (GridLayoutBean)((Object)processor.sync((ReadInterface)new ResourceRead<GridLayoutBean>(configuration){

            public GridLayoutBean perform(ReadGraph graph) throws DatabaseException {
                ViewsResources VIEW = ViewsResources.getInstance((ReadGraph)graph);
                Integer columns = (Integer)graph.getPossibleRelatedValue(this.resource, VIEW.GridLayout_columnCount, (Binding)Bindings.INTEGER);
                Integer horizontalSpacing = (Integer)graph.getPossibleRelatedValue(this.resource, VIEW.GridLayout_horizontalSpacing, (Binding)Bindings.INTEGER);
                Integer verticalSpacing = (Integer)graph.getPossibleRelatedValue(this.resource, VIEW.GridLayout_verticalSpacing, (Binding)Bindings.INTEGER);
                ExtendedMargins extendedMargins = (ExtendedMargins)graph.getPossibleRelatedValue(this.resource, VIEW.GridLayout_extendedMargins, EXTENDED_MARGINS_BINDING);
                GridLayoutBean layout = new GridLayoutBean();
                layout.numColumns = columns;
                layout.horizontalSpacing = horizontalSpacing;
                layout.verticalSpacing = verticalSpacing;
                layout.marginLeft = extendedMargins.left;
                layout.marginRight = extendedMargins.right;
                layout.marginTop = extendedMargins.top;
                layout.marginBottom = extendedMargins.bottom;
                return layout;
            }
        }));
    }

    public static GridDataBean getGridData(RequestProcessor processor, Resource configuration) throws DatabaseException {
        return (GridDataBean)((Object)processor.sync((ReadInterface)new ResourceRead<GridDataBean>(configuration){

            public GridDataBean perform(ReadGraph graph) throws DatabaseException {
                ViewsResources VIEW = ViewsResources.getInstance((ReadGraph)graph);
                GridDataBean data = new GridDataBean();
                data.horizontalSpan = (Integer)graph.getPossibleRelatedValue(this.resource, VIEW.GridLayout_GridData_horizontalSpan, (Binding)Bindings.INTEGER);
                data.grabExcessHorizontalSpace = (Boolean)graph.getPossibleRelatedValue(this.resource, VIEW.GridLayout_GridData_horizontalGrab, (Binding)Bindings.BOOLEAN);
                data.grabExcessVerticalSpace = (Boolean)graph.getPossibleRelatedValue(this.resource, VIEW.GridLayout_GridData_verticalGrab, (Binding)Bindings.BOOLEAN);
                data.horizontalAlignment = (Integer)graph.getPossibleRelatedValue(this.resource, VIEW.GridLayout_GridData_horizontalAlignment, (Binding)Bindings.INTEGER);
                data.verticalAlignment = (Integer)graph.getPossibleRelatedValue(this.resource, VIEW.GridLayout_GridData_verticalAlignment, (Binding)Bindings.INTEGER);
                data.widthHint = (Integer)graph.getPossibleRelatedValue(this.resource, VIEW.GridLayout_GridData_preferredWidth, (Binding)Bindings.INTEGER);
                data.heightHint = (Integer)graph.getPossibleRelatedValue(this.resource, VIEW.GridLayout_GridData_preferredHeight, (Binding)Bindings.INTEGER);
                return data;
            }
        }));
    }

    public static RowLayoutBean getRowLayout(RequestProcessor processor, Resource configuration) throws DatabaseException {
        return (RowLayoutBean)((Object)processor.sync((ReadInterface)new ResourceRead<RowLayoutBean>(configuration){

            public RowLayoutBean perform(ReadGraph graph) throws DatabaseException {
                ViewsResources VIEW = ViewsResources.getInstance((ReadGraph)graph);
                Integer type = (Integer)graph.getPossibleRelatedValue(this.resource, VIEW.RowLayout_type, (Binding)Bindings.INTEGER);
                Integer spacing = (Integer)graph.getPossibleRelatedValue(this.resource, VIEW.RowLayout_spacing, (Binding)Bindings.INTEGER);
                Boolean center = (Boolean)graph.getPossibleRelatedValue(this.resource, VIEW.RowLayout_center, (Binding)Bindings.BOOLEAN);
                Boolean fill = (Boolean)graph.getPossibleRelatedValue(this.resource, VIEW.RowLayout_fill, (Binding)Bindings.BOOLEAN);
                Boolean justify = (Boolean)graph.getPossibleRelatedValue(this.resource, VIEW.RowLayout_justify, (Binding)Bindings.BOOLEAN);
                Boolean pack = (Boolean)graph.getPossibleRelatedValue(this.resource, VIEW.RowLayout_pack, (Binding)Bindings.BOOLEAN);
                Boolean wrap = (Boolean)graph.getPossibleRelatedValue(this.resource, VIEW.RowLayout_wrap, (Binding)Bindings.BOOLEAN);
                ExtendedMargins extendedMargins = (ExtendedMargins)graph.getPossibleRelatedValue(this.resource, VIEW.RowLayout_extendedMargins, EXTENDED_MARGINS_BINDING);
                RowLayoutBean layout = new RowLayoutBean();
                layout.type = type;
                layout.spacing = spacing;
                layout.center = center;
                layout.fill = fill;
                layout.justify = justify;
                layout.pack = pack;
                layout.wrap = wrap;
                layout.marginLeft = extendedMargins.left;
                layout.marginRight = extendedMargins.right;
                layout.marginTop = extendedMargins.top;
                layout.marginBottom = extendedMargins.bottom;
                return layout;
            }
        }));
    }

    public static RowDataBean getRowData(RequestProcessor processor, Resource configuration) throws DatabaseException {
        return (RowDataBean)((Object)processor.sync((ReadInterface)new ResourceRead<RowDataBean>(configuration){

            public RowDataBean perform(ReadGraph graph) throws DatabaseException {
                ViewsResources VIEW = ViewsResources.getInstance((ReadGraph)graph);
                RowDataBean data = new RowDataBean();
                data.width = (Integer)graph.getPossibleRelatedValue(this.resource, VIEW.GridLayout_GridData_preferredWidth, (Binding)Bindings.INTEGER);
                data.height = (Integer)graph.getPossibleRelatedValue(this.resource, VIEW.GridLayout_GridData_preferredHeight, (Binding)Bindings.INTEGER);
                return data;
            }
        }));
    }

    public static int getStyle(RequestProcessor processor, Resource configuration) throws DatabaseException {
        return (Integer)processor.sync((ReadInterface)new ResourceRead<Integer>(configuration){

            public Integer perform(ReadGraph graph) throws DatabaseException {
                ViewsResources VIEW = ViewsResources.getInstance((ReadGraph)graph);
                int result = 0;
                for (Resource constant : graph.getObjects(this.resource, VIEW.Control_Style_HasConstant)) {
                    int value = (Integer)graph.getValue(constant, (Binding)Bindings.INTEGER);
                    result |= value;
                }
                return result;
            }
        });
    }

    public static ColumnBean getColumn(RequestProcessor processor, Resource configuration) throws DatabaseException {
        return (ColumnBean)((Object)processor.sync((ReadInterface)new ResourceRead<ColumnBean>(configuration){

            public ColumnBean perform(ReadGraph graph) throws DatabaseException {
                ViewsResources VIEW = ViewsResources.getInstance((ReadGraph)graph);
                String key = (String)graph.getPossibleRelatedValue(this.resource, VIEW.Explorer_Column_HasKey, (Binding)Bindings.STRING);
                String label = (String)graph.getPossibleRelatedValue(this.resource, VIEW.Explorer_Column_HasLabel, (Binding)Bindings.STRING);
                String alignment = (String)graph.getPossibleRelatedValue(this.resource, VIEW.Explorer_Column_HasAlignment, (Binding)Bindings.STRING);
                Integer width = (Integer)graph.getPossibleRelatedValue(this.resource, VIEW.Explorer_Column_HasWidth, (Binding)Bindings.INTEGER);
                String tooltip = (String)graph.getPossibleRelatedValue(this.resource, VIEW.Explorer_Column_HasTooltip, (Binding)Bindings.STRING);
                Boolean grab = (Boolean)graph.getPossibleRelatedValue(this.resource, VIEW.Explorer_Column_HasGrab, (Binding)Bindings.BOOLEAN);
                Integer weight = (Integer)graph.getPossibleRelatedValue(this.resource, VIEW.Explorer_Column_HasWeight, (Binding)Bindings.INTEGER);
                ColumnBean bean = new ColumnBean();
                bean.key = key;
                bean.label = label;
                bean.alignment = alignment;
                bean.width = width;
                bean.tooltip = tooltip;
                bean.grab = grab;
                bean.weight = weight;
                return bean;
            }
        }));
    }

    public static <T> void listen(Resource configuration, Variable context, String relationURI, final Binding binding, final Function1<T, Boolean> function) throws DatabaseException {
        Simantics.getSession().async((ReadInterface)new TernaryRead<Resource, Variable, String, T>(configuration, context, relationURI){

            public T perform(ReadGraph graph) throws DatabaseException {
                Object value = graph.getRelatedValue2((Resource)this.parameter, graph.getResource((String)this.parameter3), this.parameter2);
                Object result = binding.createDefaultUnchecked();
                try {
                    binding.readFrom(Bindings.getBinding((Datatype)binding.type()), value, result);
                }
                catch (BindingException e) {
                    throw new DatabaseException((Throwable)e);
                }
                return result;
            }
        }, new Listener<T>(){
            private boolean disposed = false;

            public void exception(Throwable t) {
            }

            public void execute(T result) {
                this.disposed = (Boolean)function.apply(result);
            }

            public boolean isDisposed() {
                return this.disposed;
            }
        });
    }

    public static <T> void listen(Resource configuration, Variable context, String relationURI, final Function1<T, Boolean> function) throws DatabaseException {
        Simantics.getSession().async((ReadInterface)new TernaryRead<Resource, Variable, String, T>(configuration, context, relationURI){

            public T perform(ReadGraph graph) throws DatabaseException {
                return graph.getRelatedValue2((Resource)this.parameter, graph.getResource((String)this.parameter3), this.parameter2);
            }
        }, new Listener<T>(){
            private boolean disposed = false;

            public void exception(Throwable t) {
            }

            public void execute(T result) {
                this.disposed = (Boolean)function.apply(result);
            }

            public boolean isDisposed() {
                return this.disposed;
            }
        });
    }

    public static Function2<Object, Object, Object> getActionFunctionDeprecated(final Resource configuration, final Resource runtime, final String relationURI) throws DatabaseException {
        return new Function2<Object, Object, Object>(){

            public Object apply(final Object selection, final Object event) {
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Resource relation = graph.getResource(relationURI);
                        Resource function = graph.getSingleObject(configuration, relation);
                        Functions.exec((RequestProcessor)graph, (Resource)function, (Object[])new Object[]{graph, runtime, selection, event});
                    }
                });
                return null;
            }
        };
    }

    public static void setWorkbenchSelection(ISelection selection) {
        ISelectionProvider provider = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getSelectionProvider();
        provider.setSelection(selection);
    }

    public static class ColumnBean
    extends Bean {
        public String key;
        public String label;
        public String alignment;
        public int width;
        public String tooltip;
        public boolean grab;
        public int weight;
    }

    public static class ExtendedMargins {
        public int left;
        public int right;
        public int top;
        public int bottom;
    }

    public static class GridDataBean
    extends LayoutDataBean {
        public int horizontalSpan;
        public boolean grabExcessHorizontalSpace;
        public boolean grabExcessVerticalSpace;
        public int horizontalAlignment;
        public int verticalAlignment;
        public int widthHint;
        public int heightHint;
    }

    public static class GridLayoutBean
    extends LayoutBean {
        public int numColumns;
        public int horizontalSpacing;
        public int verticalSpacing;
    }

    public static class LayoutBean
    extends Bean {
        public int marginLeft;
        public int marginRight;
        public int marginTop;
        public int marginBottom;
    }

    public static class LayoutDataBean
    extends Bean {
    }

    public static class RowDataBean
    extends LayoutDataBean {
        public int width;
        public int height;
    }

    public static class RowLayoutBean
    extends LayoutBean {
        public int type;
        public int spacing;
        public boolean center;
        public boolean fill;
        public boolean justify;
        public boolean pack;
        public boolean wrap;
    }
}

