/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.simantics.db.DatabaseUserAgent;
import org.simantics.db.Driver;
import org.simantics.db.internal.Activator;

public final class Manager {
    private Manager() {
    }

    public static Driver getDriver(String id) {
        Map<String, Driver> drivers = Manager.collectDrivers();
        return drivers.get(id);
    }

    private static Map<String, Driver> collectDrivers() {
        List<ServiceReference> serviceReferences;
        BundleContext context = Activator.getContext();
        try {
            serviceReferences = context.getServiceReferences(Driver.class, null);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            serviceReferences = Collections.emptyList();
        }
        HashMap<String, Driver> drivers = new HashMap<String, Driver>(serviceReferences.size());
        for (ServiceReference reference : serviceReferences) {
            Driver driver = (Driver)context.getService(reference);
            String driverName = driver.getName();
            if (driverName == null || driverName.isEmpty()) continue;
            drivers.put(driverName, driver);
        }
        return drivers;
    }

    public static DatabaseUserAgent getUserAgent(String id) {
        Map<String, DatabaseUserAgent> agents = Manager.collectUserAgents();
        return agents.get(id);
    }

    private static Map<String, DatabaseUserAgent> collectUserAgents() {
        List<ServiceReference> serviceReferences;
        BundleContext context = Activator.getContext();
        try {
            serviceReferences = context.getServiceReferences(DatabaseUserAgent.class, null);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            serviceReferences = Collections.emptyList();
        }
        HashMap<String, DatabaseUserAgent> drivers = new HashMap<String, DatabaseUserAgent>(serviceReferences.size());
        for (ServiceReference reference : serviceReferences) {
            DatabaseUserAgent dbua = (DatabaseUserAgent)context.getService(reference);
            String driverName = dbua.getId();
            if (driverName == null || driverName.isEmpty()) continue;
            drivers.put(driverName, dbua);
        }
        return drivers;
    }
}

