/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.selectionview.ComparableTabContributor;
import org.simantics.selectionview.PropertyTabContributor;
import org.simantics.selectionview.SelectionProcessor;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.ui.TableSelection;
import org.simantics.spreadsheet.ui.editor.NoCellTab;
import org.simantics.spreadsheet.ui.editor.TextCellTab;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

public class SpreadsheetSelectionProcessor
implements SelectionProcessor<Collection<?>, ReadGraph> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection<?> process(Collection<?> selection, ReadGraph graph) {
        try {
            if (selection == null) {
                return Collections.emptyList();
            }
            if (selection.size() != 3) {
                return Collections.emptyList();
            }
            Iterator<?> it = selection.iterator();
            Variable variable = (Variable)it.next();
            it.next();
            TableSelection sel = (TableSelection)it.next();
            int row = sel.getRows()[0];
            int column = sel.getColumns()[0];
            String location = SpreadsheetUtils.cellName((int)row, (int)column);
            ArrayList<ComparableTabContributor> result = new ArrayList<ComparableTabContributor>();
            Variable cell = variable.getPossibleChild(graph, location);
            if (cell != null) {
                SpreadsheetResource sr = SpreadsheetResource.getInstance((ReadGraph)graph);
                Resource type = (Resource)cell.getPossiblePropertyValue(graph, "Type");
                if (!sr.TextCell.equals(type)) return Collections.emptyList();
                result.add(new ComparableTabContributor((PropertyTabContributor)new TextCellTab(), 3.0, (Object)cell, "Configuration"));
                return result;
            } else {
                result.add(new ComparableTabContributor((PropertyTabContributor)new NoCellTab(), 3.0, (Object)new NoCellTab.NoCellInput(variable, location), "Configuration"));
            }
            return result;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return Collections.emptyList();
        }
    }
}

