/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.arrays;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.browsing.ui.common.modifiers.EnumeratedValue;
import org.simantics.browsing.ui.common.modifiers.Enumeration;
import org.simantics.browsing.ui.common.node.AbstractNode;
import org.simantics.browsing.ui.common.node.IModifiableNode;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.properties.widgets.arrays.ComboBoxModifier;
import org.simantics.ui.SimanticsUI;

public class RedeclarationNode
extends AbstractNode<Resource>
implements IModifiableNode {
    private Resource module;

    public RedeclarationNode(ReadGraph graph, Resource module, Resource enumeration) {
        super((Object)enumeration);
        this.module = module;
    }

    public Resource getReplacingEnumeration(ReadGraph graph) {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Resource result = null;
        try {
            Resource redeclaration = this.getRedeclaration(graph);
            if (redeclaration != null) {
                result = graph.getSingleObject(redeclaration, sr.Redeclaration_replacingEnumeration);
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Resource getModule() {
        return this.module;
    }

    public void setModule(Resource module) {
        this.module = module;
    }

    public Resource getRedeclaration(ReadGraph graph) {
        try {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            for (Resource redeclaration : (Collection)graph.syncRequest((Read)new ObjectsWithType(this.module, sr.Module_redeclaration, sr.Redeclaration))) {
                Resource replacedEnumeration = graph.getPossibleObject(redeclaration, sr.Redeclaration_replacedEnumeration);
                if (replacedEnumeration == null || !replacedEnumeration.equals(this.getReplacedEnumeration())) continue;
                return redeclaration;
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setRedeclaration(WriteGraph graph, Resource redeclaration) {
        try {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            Resource oldRedeclaration = this.getRedeclaration((ReadGraph)graph);
            if (oldRedeclaration != null || redeclaration == null) {
                graph.deny(this.module, sr.Module_redeclaration, oldRedeclaration);
            }
            if (redeclaration != null) {
                graph.claim(this.module, sr.Module_redeclaration, redeclaration);
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public Resource getReplacedEnumeration() {
        return (Resource)this.data;
    }

    public Labeler.Modifier getModifier(String columnId) {
        if (!"Replaced with".equals(columnId)) {
            return null;
        }
        ComboBoxModifier cbm = null;
        try {
            cbm = (ComboBoxModifier)SimanticsUI.getSession().syncRequest((Read)new Read<ComboBoxModifier<Resource>>(){

                public ComboBoxModifier<Resource> perform(ReadGraph graph) throws DatabaseException {
                    Resource enumeration2;
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    ArrayList<EnumeratedValue> values = new ArrayList<EnumeratedValue>();
                    Resource configuration = graph.getSingleObject(RedeclarationNode.this.module, l0.PartOf);
                    for (Resource enumeration2 : (Collection)graph.syncRequest((Read)new ObjectsWithType(configuration, l0.ConsistsOf, sr.Enumeration))) {
                        String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)enumeration2);
                        values.add(new EnumeratedValue(name, (Object)enumeration2));
                    }
                    if (values.size() == 0) {
                        return null;
                    }
                    values.add(0, new EnumeratedValue("", null));
                    enumeration2 = new Enumeration(values);
                    ComboBoxModifier<Resource> cbm = new ComboBoxModifier<Resource>(graph.getSession(), (Enumeration)enumeration2, RedeclarationNode.this.getReplacingEnumeration(graph)){

                        @Override
                        protected void modifyWithObject(WriteGraph graph, Resource oldEnumObject, Resource enumObject) throws DatabaseException {
                            if (enumObject == null) {
                                RedeclarationNode.this.setRedeclaration(graph, null);
                            } else if (!enumObject.equals(oldEnumObject)) {
                                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                                Resource redeclaration = GraphUtils.create2((WriteGraph)graph, (Resource)sr.Redeclaration, (Object[])new Object[]{sr.Redeclaration_replacedEnumeration, RedeclarationNode.this.getReplacedEnumeration(), sr.Redeclaration_replacingEnumeration, enumObject});
                                RedeclarationNode.this.setRedeclaration(graph, redeclaration);
                            }
                        }
                    };
                    return cbm;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return cbm;
    }
}

