/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Write;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.ExceptionUtils;

public class RemoveNodeHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Resource[] resources = ResourceAdaptionUtils.toResources((Object)sel);
        if (resources.length == 0) {
            return null;
        }
        MessageDialog dialog = new MessageDialog(shell, "Remove Item", null, "Are you sure?", 0, new String[]{"OK", "Cancel"}, 0);
        dialog.create();
        if (dialog.open() == 0) {
            RemoveNodeHandler.deleteItem(resources);
        }
        return null;
    }

    public static void deleteItem(final Resource[] resources) {
        try {
            SimanticsUI.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException, CancelTransactionException {
                    Resource[] resourceArray = resources;
                    int n = resources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Resource r = resourceArray[n2];
                        RemoverUtil.remove((WriteGraph)graph, (Resource)r);
                        ++n2;
                    }
                }
            });
        }
        catch (DatabaseException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
        }
    }
}

