/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.editor.participant;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.participant.ConnectTool2;
import org.simantics.diagram.participant.ControlPoint;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.connection.IConnectionAdvisor;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementClasses;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.element.impl.Element;
import org.simantics.g2d.elementclass.BranchPointClass;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.g2d.routing.IConnection;
import org.simantics.g2d.routing.IRouter2;
import org.simantics.g2d.routing.TrivialRouter2;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.structural2.modelingRules.ConnectionJudgement;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.editor.participant.SysdynConnectionBuilder;
import org.simantics.sysdyn.ui.editor.participant.SysdynPointerInteractor;
import org.simantics.sysdyn.ui.elements.CloudFactory;
import org.simantics.sysdyn.ui.elements.SysdynElementHints;
import org.simantics.sysdyn.ui.elements.ValveFactory;
import org.simantics.sysdyn.ui.elements.connections.ConnectionClasses;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;

public class SysdynConnectTool
extends ConnectTool2 {
    public SysdynConnectTool(TerminalUtil.TerminalInfo startTerminal, int mouseId, Point2D startCanvasPos) {
        super(startTerminal, mouseId, startCanvasPos);
    }

    @SGNodeReflection.SGInit
    public void initSG(G2DParentNode parent) {
        this.ghostNode = (G2DParentNode)parent.addNode(G2DParentNode.class);
        this.ghostNode.setZIndex(15);
        ShapeNode pathNode = (ShapeNode)this.ghostNode.getOrCreateNode("path", ShapeNode.class);
        pathNode.setColor((Paint)Color.BLACK);
        pathNode.setStroke((Stroke)new BasicStroke(1.0f));
        pathNode.setScaleStroke(true);
        pathNode.setZIndex(0);
        G2DParentNode points = (G2DParentNode)this.ghostNode.getOrCreateNode("points", G2DParentNode.class);
        points.setZIndex(1);
        this.updateSG();
    }

    protected TerminalUtil.TerminalInfo createFlag(EdgeVisuals.EdgeEnd connectionEnd) {
        ElementClass flagClass = this.elementClassProvider.get(ElementClasses.FLAG);
        IElement e = Element.spawnNew((ElementClass)flagClass);
        e.setHint(FlagClass.KEY_FLAG_TYPE, (Object)SysdynConnectTool.endToFlagType((EdgeVisuals.EdgeEnd)connectionEnd));
        e.setHint(FlagClass.KEY_FLAG_MODE, (Object)FlagClass.Mode.Internal);
        TerminalUtil.TerminalInfo ti = new TerminalUtil.TerminalInfo();
        ti.e = e;
        ArrayList terminals = new ArrayList();
        ElementUtils.getTerminals((IElement)e, terminals, (boolean)false);
        ti.t = (Topology.Terminal)terminals.get(0);
        ti.posElem = TerminalUtil.getTerminalPosOnElement((IElement)e, (Topology.Terminal)ti.t);
        ti.posDia = TerminalUtil.getTerminalPosOnDiagram((IElement)e, (Topology.Terminal)ti.t);
        return ti;
    }

    private List<Segment> toSegments(Deque<ControlPoint> points) {
        if (points.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Segment> segments = new ArrayList<Segment>();
        Iterator<ControlPoint> it = points.iterator();
        ControlPoint prev = it.next();
        while (it.hasNext()) {
            ControlPoint next = it.next();
            segments.add(new Segment(prev, next));
            prev = next;
        }
        return segments;
    }

    protected void updateSG() {
        if (this.controlPoints.isEmpty()) {
            return;
        }
        IRouter2 router = (IRouter2)ElementUtils.getHintOrDefault((IHintContext)this.diagram, (IHintContext.Key)DiagramHints.ROUTE_ALGORITHM, (Object)TrivialRouter2.INSTANCE);
        final List<Segment> segments = this.toSegments(this.controlPoints);
        router.route((IConnection)new SysdynConnection(){

            public Collection<? extends Object> getSegments() {
                return segments;
            }

            public IConnection.Connector getBegin(Object seg) {
                return this.getConnector(((Segment)seg).begin);
            }

            public IConnection.Connector getEnd(Object seg) {
                return this.getConnector(((Segment)seg).end);
            }

            private IConnection.Connector getConnector(ControlPoint cp) {
                IConnection.Connector c = new IConnection.Connector();
                c.x = cp.getPosition().getX();
                c.y = cp.getPosition().getY();
                c.allowedDirections = 15;
                TerminalUtil.TerminalInfo ti = cp.getAttachedTerminal();
                if (ti != null && ti != SysdynConnectTool.this.startFlag && ti != SysdynConnectTool.this.endFlag) {
                    if (ti.e.getElementClass().containsClass(ValveFactory.ValveSceneGraph.class)) {
                        Rectangle2D bounds = ElementUtils.getElementBoundsOnDiagram((IElement)ti.e).getBounds2D();
                        c.parentObstacle = new Rectangle2D.Double(bounds.getCenterX() - 0.5, bounds.getCenterY() - 0.5, 1.0, 1.0);
                    } else {
                        c.parentObstacle = ElementUtils.getElementBoundsOnDiagram((IElement)ti.e).getBounds2D();
                    }
                } else {
                    c.parentObstacle = ti != null && ti == SysdynConnectTool.this.startFlag ? GeometryUtils.transformRectangle((AffineTransform)AffineTransform.getTranslateInstance(c.x, c.y), (Rectangle2D)ElementUtils.getElementBoundsOnDiagram((IElement)ti.e).getBounds2D()) : (ti != null && SysdynConnectTool.this.isEndingInFlag() ? GeometryUtils.transformRectangle((AffineTransform)AffineTransform.getTranslateInstance(c.x, c.y), (Rectangle2D)CloudFactory.CLOUD_IMAGE.getBounds()) : GeometryUtils.transformRectangle((AffineTransform)AffineTransform.getTranslateInstance(c.x, c.y), (Rectangle2D)BranchPointClass.DEFAULT_IMAGE2.getBounds()));
                }
                return c;
            }

            public void setPath(Object seg, Path2D path) {
                ((Segment)seg).path = (Path2D)path.clone();
            }
        });
        Path2D.Double path = new Path2D.Double();
        for (Segment seg : segments) {
            if (seg.path == null) continue;
            ((Path2D)path).append(seg.path.getPathIterator(null), true);
        }
        ShapeNode pathNode = (ShapeNode)this.ghostNode.getOrCreateNode("path", ShapeNode.class);
        pathNode.setShape((Shape)path);
        this.setDirty();
    }

    protected Object canConnect(final IConnectionAdvisor advisor, final IElement endElement, final Topology.Terminal endTerminal) {
        Topology.Terminal st;
        final IElement se = this.startTerminal != null ? this.startTerminal.e : this.startFlag.e;
        Topology.Terminal terminal = st = this.startTerminal != null ? this.startTerminal.t : null;
        if (se.equals(endElement)) {
            return null;
        }
        if (Boolean.FALSE.equals(this.diagram.getHint(DiagramHints.KEY_USE_CONNECTION_FLAGS)) && endElement == null) {
            return null;
        }
        if (endElement == null && endTerminal == null) {
            return advisor.canBeConnected(null, se, st, endElement, endTerminal);
        }
        try {
            return SimanticsUI.getSession().syncRequest((Read)new Read<Object>(){

                public Object perform(ReadGraph g) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
                    StaticObjectAdapter soa = (StaticObjectAdapter)endElement.getElementClass().getSingleItem(StaticObjectAdapter.class);
                    Resource end = (Resource)soa.adapt(Resource.class);
                    ElementClass dependency = SysdynConnectTool.this.elementClassProvider.get(ConnectionClasses.DEPENDENCY);
                    ElementClass flow = SysdynConnectTool.this.elementClassProvider.get(ConnectionClasses.FLOW);
                    ElementClass currentConnection = SysdynConnectTool.this.elementClassProvider.get(ElementClasses.CONNECTION);
                    if (currentConnection.equals((Object)dependency)) {
                        if (end.equals(sr.CloudSymbol)) {
                            return null;
                        }
                        soa = (StaticObjectAdapter)se.getElementClass().getSingleItem(StaticObjectAdapter.class);
                        Resource start = (Resource)soa.adapt(Resource.class);
                        if (g.isInheritedFrom(start, sr.ModuleSymbol) && !end.equals(sr.InputSymbol)) {
                            return null;
                        }
                        if (end.equals(sr.ShadowSymbol)) {
                            return null;
                        }
                    } else if (currentConnection.equals((Object)flow)) {
                        if (!(end.equals(sr.StockSymbol) || end.equals(sr.ValveSymbol) || end.equals(sr.CloudSymbol))) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                    if (advisor == null) {
                        return Boolean.TRUE;
                    }
                    return advisor.canBeConnected((Object)g, se, st, endElement, endTerminal);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected boolean processMouseMove(MouseEvent.MouseMovedEvent me) {
        Pair canConnect;
        this.mouseHasMoved = true;
        Point2D mouseControlPos = me.controlPosition;
        Point2D mouseCanvasPos = this.util.controlToCanvas(mouseControlPos, (Point2D)new Point2D.Double());
        ISnapAdvisor snapAdvisor = (ISnapAdvisor)this.getHint(DiagramHints.SNAP_ADVISOR);
        if (snapAdvisor != null) {
            snapAdvisor.snap(mouseCanvasPos);
        }
        this.lastMouseCanvasPos.setLocation(mouseCanvasPos);
        if (this.isEndingInFlag()) {
            this.endFlagNode.setTransform(AffineTransform.getTranslateInstance(mouseCanvasPos.getX(), mouseCanvasPos.getY()));
        }
        List<TerminalUtil.TerminalInfo> tiList = ((SysdynPointerInteractor)this.pi).pickTerminals(me.controlPosition);
        TerminalUtil.TerminalInfo ti = null;
        IConnectionAdvisor advisor = (IConnectionAdvisor)this.diagram.getHint(DiagramHints.CONNECTION_ADVISOR);
        for (TerminalUtil.TerminalInfo info : tiList) {
            Object canConnect2;
            if (advisor == null || info.e == null || info.t == null || (canConnect2 = this.canConnect(advisor, info.e, info.t)) == null) continue;
            ti = info;
            break;
        }
        if (ti != null && !this.isStartTerminal(ti.e, ti.t) && (canConnect = this.canConnect(ti.e, ti.t)) != null) {
            this.connectionJudgment = (ConnectionJudgement)canConnect.first;
            if (!this.isEndingInFlag() || !TerminalUtil.isSameTerminal((TerminalUtil.TerminalInfo)ti, (TerminalUtil.TerminalInfo)this.endTerminal)) {
                ((ControlPoint)this.controlPoints.getLast()).setPosition(ti.posDia).setAttachedToTerminal(ti);
                this.endTerminal = ti;
            }
            if (this.inFlowMode() && this.flowInProgress() && !this.startTerminals.isEmpty()) {
                this.endWithoutTerminal(this.lastMouseCanvasPos, true);
            } else {
                this.endWithoutTerminal(this.lastMouseCanvasPos, this.shouldEndWithFlag((MouseEvent)me));
            }
            this.updateSG();
            return false;
        }
        this.connectionJudgment = null;
        if (this.isEndTerminalDefined()) {
            ((ControlPoint)this.controlPoints.getLast()).setPosition(mouseCanvasPos).setDirection(this.calculateCurrentBranchPointDirection()).setAttachedToTerminal(null);
            this.endTerminal = null;
        } else {
            ((ControlPoint)this.controlPoints.getLast()).setPosition(mouseCanvasPos).setDirection(this.calculateCurrentBranchPointDirection());
        }
        if (this.inFlowMode() && this.flowInProgress() && !this.startTerminals.isEmpty()) {
            this.endWithoutTerminal(this.lastMouseCanvasPos, true);
        } else {
            this.endWithoutTerminal(this.lastMouseCanvasPos, this.shouldEndWithFlag((MouseEvent)me));
        }
        this.updateSG();
        return false;
    }

    protected boolean processMouseButtonPress(MouseEvent.MouseButtonPressedEvent e) {
        MouseEvent.MouseButtonPressedEvent me = e;
        if (!this.mouseHasMoved) {
            return true;
        }
        if (me.button == 1 || me.button == 2 && this.flowInProgress() && !this.inFlowMode()) {
            Point2D mouseControlPos = me.controlPosition;
            Point2D mouseCanvasPos = this.util.getInverseTransform().transform(mouseControlPos, new Point2D.Double());
            ISnapAdvisor snapAdvisor = (ISnapAdvisor)this.getHint(DiagramHints.SNAP_ADVISOR);
            if (snapAdvisor != null) {
                snapAdvisor.snap(mouseCanvasPos);
            }
            if (this.isEndTerminalDefined()) {
                this.createConnection();
                this.remove();
                return true;
            }
            if (!this.startTerminals.isEmpty() && ((me.stateMask & 0x200) != 0 || this.inFlowMode() && this.flowInProgress())) {
                Pair pair = this.canConnect(null, null);
                if (pair != null) {
                    this.connectionJudgment = (ConnectionJudgement)pair.first;
                    this.selectedStartTerminal = (TerminalUtil.TerminalInfo)pair.second;
                    this.createConnection();
                    this.setDirty();
                    this.remove();
                } else {
                    ErrorLogger.defaultLogWarning((String)"Can't resolve connection type for new connection.", null);
                }
                return true;
            }
            if (this.routePointsAllowed() && (me.stateMask & 0x2C0) == 0) {
                this.controlPoints.add(this.newControlPointWithCalculatedDirection(mouseCanvasPos));
                this.resetForcedBranchPointDirection();
                this.updateSG();
            }
        }
        return true;
    }

    private boolean inFlowMode() {
        return SysdynElementHints.FLOW_TOOL.equals(this.getHint(SysdynElementHints.SYSDYN_KEY_TOOL));
    }

    private boolean flowInProgress() {
        return this.elementClassProvider.get(ElementClasses.CONNECTION).equals((Object)this.elementClassProvider.get(ConnectionClasses.FLOW));
    }

    protected void createConnection() {
        if (this.connectionJudgment == null) {
            return;
        }
        final ConnectionJudgement judgment = this.connectionJudgment;
        final SysdynConnectionBuilder builder = new SysdynConnectionBuilder(this.diagram);
        final Deque controlPoints = this.controlPoints;
        final TerminalUtil.TerminalInfo startTerminal = this.startTerminal;
        final TerminalUtil.TerminalInfo endTerminal = this.endTerminal;
        SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                builder.create(graph, judgment, controlPoints, startTerminal, endTerminal);
            }
        }, (Callback)new Callback<DatabaseException>(){

            public void run(DatabaseException parameter) {
                if (parameter != null) {
                    ExceptionUtils.logAndShowError((Throwable)parameter);
                }
            }
        });
    }

    static class Segment {
        public final ControlPoint begin;
        public final ControlPoint end;
        public Path2D path;

        public Segment(ControlPoint begin, ControlPoint end) {
            this.begin = begin;
            this.end = end;
        }

        public String toString() {
            return "Segment[begin=" + this.begin + ", end=" + this.end + ", path=" + this.path + "]";
        }
    }

    public static interface SysdynConnection
    extends IConnection {
    }
}

