/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.server.ProCoreException;
import org.simantics.db.server.internal.Channel;
import org.simantics.db.server.internal.ConnectionThread;
import org.simantics.db.server.internal.Method;
import org.simantics.db.server.internal.MethodQueue;
import org.simantics.db.server.internal.NotConnectedException;

class Connection {
    private static final boolean DEBUG = false;
    private static int lastSentTokenNumber = 0;
    private final ConnectionThread connectionThread;
    private InetSocketAddress address;
    private Channel channel;
    private CountDownLatch connectionCreated;
    private ProCoreException exception;
    private ByteBuffer readBuffer;

    Connection(ConnectionThread connectionThread) {
        this.connectionThread = connectionThread;
        this.init4Connection(InetSocketAddress.createUnresolved("", 0));
    }

    public String toString() {
        return "Connection address=" + this.address + " token=" + lastSentTokenNumber;
    }

    boolean addressNotInitialized() {
        return this.address.equals(InetSocketAddress.createUnresolved("", 0));
    }

    void register(Selector selector) throws ClosedChannelException {
        this.channel.register(selector, this);
    }

    InetSocketAddress getAddress() {
        return this.address;
    }

    boolean equalsAddress(InetSocketAddress address) {
        return address.equals(address);
    }

    void init4Connection(InetSocketAddress address) {
        this.address = address;
        if (this.channel != null && this.channel.isConnected()) {
            this.channel.disconnect();
        }
        this.channel = new Channel();
        this.connectionCreated = new CountDownLatch(1);
        this.exception = null;
        this.readBuffer = this.connectionThread.getInputBuffer();
    }

    void prepare4Connection(SocketChannel socketChannel) throws ProCoreException, IOException {
        if (this.isConnected()) {
            throw new ProCoreException("Illegal state exception. Already connected.");
        }
        if (this.address.isUnresolved()) {
            this.address = new InetSocketAddress(this.address.getHostName(), this.address.getPort());
        }
        if (this.address.getPort() == 0) {
            throw new ProCoreException("Port 0 not supported as connection address.");
        }
        this.channel.prepare4Connection(socketChannel, this.address);
    }

    void wait4Connection() throws InterruptedException {
        this.connectionCreated.await();
    }

    synchronized void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        this.channel.disconnect();
    }

    private void throwIOExceptionFromRead(IOException e) throws IOException {
        this.disconnect();
        if (e != null) {
            throw e;
        }
        throw new IOException("Failed to read.");
    }

    private void sendMessage(ByteBuffer byteBuffer) throws IOException, InterruptedException {
        int left = byteBuffer.remaining();
        while (left > 0) {
            ByteBuffer slice = byteBuffer.slice();
            int size = Math.min(left, 1000000);
            slice.limit(size);
            this.sendBuffer(slice);
            int position = byteBuffer.position() + size;
            byteBuffer.position(position);
            left -= size;
        }
    }

    private void sendBuffer(ByteBuffer byteBuffer) throws IOException, InterruptedException {
        int left = byteBuffer.remaining();
        while (left > 0) {
            int n = this.channel.socket().write(byteBuffer);
            if (n > 0) {
                left -= n;
                continue;
            }
            Thread.yield();
            if (left <= 0) continue;
            Logger.defaultLogTrace((String)("Could not send the whole byte buffer, left count = " + left + ", buffer remaining = " + byteBuffer.remaining() + ", write return =" + n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void call(MessageHeader messageHeader, Method method) throws IOException, InterruptedException {
        byte[] bytes = new byte[20];
        ByteBuffer header = ByteBuffer.wrap(bytes, 0, 20);
        header.order(ByteOrder.LITTLE_ENDIAN);
        header.putInt(messageHeader.lastTokenIn);
        header.putInt(messageHeader.token);
        int messageNumber = method.requestNumber;
        header.putInt(messageNumber);
        header.putInt(0);
        ByteBuffer data = method.serialize(ByteOrder.LITTLE_ENDIAN);
        header.putInt(data.position());
        header.clear();
        Connection connection = this;
        synchronized (connection) {
            this.sendMessage(header);
            data.limit(data.position());
            data.rewind();
            this.sendMessage(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendMethod(MethodQueue mq, Method m, int lastTokenIn) throws ProCoreException, IOException, InterruptedException {
        m.prepareForSendingRequest();
        Connection connection = this;
        synchronized (connection) {
            MessageHeader messageHeader = new MessageHeader(++lastSentTokenNumber, lastTokenIn);
            m.setToken(messageHeader.token);
            mq.add(m);
            this.call(messageHeader, m);
        }
    }

    void onRead() throws IOException {
        if (this.readBuffer.remaining() < 1) {
            this.throwIOExceptionFromRead(new IOException("Internal error. Assertion failed. Read buffer full in Connection.onRead."));
        }
        int n = -1;
        try {
            n = this.channel.socket().read(this.readBuffer);
        }
        catch (IOException e) {
            this.throwIOExceptionFromRead(e);
        }
        if (n < 0) {
            this.throwIOExceptionFromRead(new IOException("Failed to read."));
        } else if (n < 1) {
            return;
        }
        try {
            this.readBuffer = this.connectionThread.handleInput(this.readBuffer, n);
        }
        catch (Throwable t) {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException("Throwable from handleInput.", t);
        }
    }

    void onConnectFailed(ProCoreException exception) {
        this.exception = exception != null ? exception : new NotConnectedException("Failed to create connection.");
        this.connectionCreated.countDown();
    }

    Connection onConnectSucceeded(SelectionKey key) {
        Connection ret = null;
        try {
            this.channel.connect(key);
            ret = this;
        }
        catch (Throwable t) {
            this.exception = new NotConnectedException("Failed to finalize connection.", t);
        }
        this.connectionCreated.countDown();
        return ret;
    }

    void onDisconnect() {
        this.disconnect();
    }

    boolean isConnected() {
        return this.channel.isConnected();
    }

    boolean isExcepted() {
        return this.exception == null;
    }

    boolean isOk() {
        return this.isConnected() && !this.isExcepted();
    }

    public static class MessageHeader {
        public int token;
        public int lastTokenIn;

        public MessageHeader(int token, int lastTokenIn) {
            this.token = token;
            this.lastTokenIn = lastTokenIn;
        }
    }
}

