/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.browser.internal.rewriters;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.browser.content.ResourceBrowserContent;
import org.simantics.debug.browser.content.ResourceBrowserRewriter;
import org.simantics.debug.browser.sections.PageHeaderSection;
import org.simantics.debug.browser.sections.RawStatementsSection;

public enum RawStatementsCreator implements ResourceBrowserRewriter
{
    INSTANCE;


    @Override
    public void rewrite(ReadGraph graph, ResourceBrowserContent content) throws DatabaseException {
        RawStatementsSection section = new RawStatementsSection();
        section.resource = content.resource;
        for (Resource predicate : graph.getPredicates(content.resource)) {
            Collection statements = graph.getStatements(content.resource, predicate);
            ArrayList<Statement> filteredStatements = new ArrayList<Statement>(statements.size());
            for (Statement statement : statements) {
                if (!statement.getPredicate().equals(predicate)) continue;
                filteredStatements.add(statement);
            }
            section.statementsByPredicates.put((Object)predicate, filteredStatements);
        }
        content.putSection(RawStatementsSection.class, section);
        PageHeaderSection hdr = content.getSection(PageHeaderSection.class);
        hdr.getHeadWriter().println("<link rel=\"stylesheet\" type=\"text/css\" href=\"/css/lookupSection.css\" />");
        hdr.getHeadWriter().println("<link rel=\"stylesheet\" type=\"text/css\" href=\"/css/rawStatements.css\" />");
        hdr.getHeadWriter().println("<link rel=\"stylesheet\" type=\"text/css\" href=\"/css/blue/style.css\" />");
    }

    @Override
    public double getPriority() {
        return 0.0;
    }
}

