/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.message.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IFilter;
import org.simantics.message.IMessageDataSchemeExtension;
import org.simantics.message.IMessageSchemeManager;
import org.simantics.message.internal.MessageDataSchemeExtension;

public class MessageSchemeManager
implements IExtensionChangeHandler,
IMessageSchemeManager {
    public static final String NAMESPACE = "org.simantics.message";
    public static final String ELEMENT_NAME = "scheme";
    public static final String EP_NAME = "messageDataScheme";
    private ExtensionTracker tracker;
    private MessageDataSchemeExtension[] extensions = new MessageDataSchemeExtension[0];

    public MessageSchemeManager() {
        this.tracker = new ExtensionTracker();
        IExtensionPoint expt = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACE, EP_NAME);
        this.loadExtensions(expt.getConfigurationElements());
        IFilter filter = ExtensionTracker.createExtensionPointFilter((IExtensionPoint)expt);
        this.tracker.registerHandler((IExtensionChangeHandler)this, filter);
    }

    private String getDescription(IConfigurationElement el) {
        IConfigurationElement[] iConfigurationElementArray = el.getChildren("description");
        if (iConfigurationElementArray.length != 0) {
            IConfigurationElement desc = iConfigurationElementArray[0];
            return desc.getValue();
        }
        return null;
    }

    private void loadExtensions(IConfigurationElement[] configurationElements) {
        String id;
        String name;
        IConfigurationElement el;
        HashSet<MessageDataSchemeExtension> newExtensions = new HashSet<MessageDataSchemeExtension>(Arrays.asList(this.extensions));
        HashMap<String, MessageDataSchemeExtension> schemes = new HashMap<String, MessageDataSchemeExtension>();
        for (MessageDataSchemeExtension ext : newExtensions) {
            schemes.put(ext.getId(), ext);
        }
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            String scheme;
            el = iConfigurationElementArray[n2];
            name = el.getName();
            if (ELEMENT_NAME.equals(name) && (id = el.getAttribute("id")) != null && (scheme = el.getAttribute(ELEMENT_NAME)) != null) {
                String description = this.getDescription(el);
                MessageDataSchemeExtension ext = (MessageDataSchemeExtension)schemes.get(id);
                if (ext != null) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Multiple contributors for message scheme '" + id + "':");
                    msg.append("\n  1st: " + ext.getSchemeElement().getContributor().getName());
                    msg.append("\n  2nd: " + el.getContributor().getName());
                    msg.append("\nUsing the first one.");
                    System.err.println(msg.toString());
                } else {
                    ext = new MessageDataSchemeExtension(el, id, scheme, description);
                    this.tracker.registerObject(el.getDeclaringExtension(), (Object)ext, 0);
                    newExtensions.add(ext);
                    schemes.put(id, ext);
                }
            }
            ++n2;
        }
        iConfigurationElementArray = configurationElements;
        n = configurationElements.length;
        n2 = 0;
        while (n2 < n) {
            el = iConfigurationElementArray[n2];
            name = el.getName();
            if ("handler".equals(name) && (id = el.getAttribute("schemeId")) != null) {
                MessageDataSchemeExtension ext = (MessageDataSchemeExtension)schemes.get(id);
                if (ext == null) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("No scheme extension for message scheme id '" + id + "'. Ignoring handler '" + el.getAttribute("handler") + "'");
                    msg.append("\nUsing the first one.");
                    System.err.println(msg.toString());
                } else {
                    IConfigurationElement prev = ext.getHandlerElement();
                    if (prev != null) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("Multiple handler contributors for message scheme '" + id + "':\n");
                        msg.append("\n   1st: " + prev.getContributor().getName());
                        msg.append("\n   2nd: " + el.getContributor().getName());
                        msg.append("\nUsing the first one.");
                        System.err.println(msg.toString());
                    } else {
                        ext.setHandlerElement(el);
                    }
                }
            }
            ++n2;
        }
        this.extensions = newExtensions.toArray(new MessageDataSchemeExtension[newExtensions.size()]);
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        this.loadExtensions(extension.getConfigurationElements());
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        HashSet<MessageDataSchemeExtension> newExtensions = new HashSet<MessageDataSchemeExtension>(Arrays.asList(this.extensions));
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.tracker.unregisterObject(extension, o);
            newExtensions.remove((IMessageDataSchemeExtension)o);
            ++n2;
        }
        this.extensions = newExtensions.toArray(new MessageDataSchemeExtension[newExtensions.size()]);
    }

    @Override
    public IMessageDataSchemeExtension[] getByScheme(String scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException("null scheme");
        }
        ArrayList<MessageDataSchemeExtension> result = new ArrayList<MessageDataSchemeExtension>();
        MessageDataSchemeExtension[] messageDataSchemeExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            MessageDataSchemeExtension ext = messageDataSchemeExtensionArray[n2];
            if (scheme.equals(ext.getScheme())) {
                result.add(ext);
            }
            ++n2;
        }
        return result.toArray(new MessageDataSchemeExtension[result.size()]);
    }
}

