/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management.install;

import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.provisional.p2.installer.InstallAdvisor;
import org.eclipse.equinox.internal.provisional.p2.installer.InstallDescription;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.simantics.project.management.P2Util;
import org.simantics.project.management.TrustAllCertificates;
import org.simantics.project.management.install.DefaultInstallAdvisor;
import org.simantics.project.management.install.InstallDescriptionParser;
import org.simantics.project.management.install.InstallUpdateProductOperation;

public class InstallerUtil {
    private static final String SYS_PROP_INSTALL_DESCRIPTION = "org.eclipse.equinox.p2.installDescription";

    public static IStatus install(InstallAdvisor advisor, InstallDescription description, IProgressMonitor monitor) throws Exception {
        if (advisor == null) {
            advisor = InstallerUtil.getDefaultAdvisor();
        }
        if (description == null) {
            description = InstallerUtil.getDefaultDescription(SubMonitor.convert((IProgressMonitor)monitor));
        }
        advisor.prepareInstallDescription(description);
        IProvisioningAgent agent = InstallerUtil.startAgent(description);
        InstallUpdateProductOperation operation = new InstallUpdateProductOperation(agent, description);
        IStatus status = advisor.performInstall(operation);
        status.isOK();
        advisor.setResult(status);
        advisor.stop();
        agent.stop();
        return status;
    }

    public static InstallDescription getDefaultDescription(SubMonitor monitor) throws Exception {
        String site = System.getProperty(SYS_PROP_INSTALL_DESCRIPTION);
        return InstallDescriptionParser.createDescription(site, monitor);
    }

    public static InstallAdvisor getDefaultAdvisor() {
        DefaultInstallAdvisor advisor = new DefaultInstallAdvisor();
        ((InstallAdvisor)advisor).start();
        return advisor;
    }

    public static IProvisioningAgent startAgent(InstallDescription description) throws Exception {
        IPath installLocation = description.getInstallLocation();
        if (installLocation == null) {
            throw new Exception("No install location");
        }
        try {
            IProvisioningAgentProvider provider = P2Util.getProvisioningAgentProvider();
            IPath agentLocation = description.getAgentLocation();
            IProvisioningAgent agent = provider.createAgent(agentLocation == null ? null : agentLocation.toFile().toURI());
            TrustAllCertificates serviceUI = new TrustAllCertificates();
            agent.registerService("org.eclipse.equinox.p2.core.UIServices", (Object)serviceUI);
            return agent;
        }
        catch (ProvisionException e) {
            throw new Exception("Cannot create agent", e);
        }
    }

    public static Object getService(BundleContext context, String name) {
        if (context == null) {
            return null;
        }
        ServiceReference reference = context.getServiceReference(name);
        if (reference == null) {
            return null;
        }
        Object result = context.getService(reference);
        context.ungetService(reference);
        return result;
    }

    public static void launchProduct(InstallDescription description) throws Exception {
        IPath installLocation = description.getInstallLocation();
        IPath toRun = installLocation.append(description.getLauncherName());
        try {
            Runtime.getRuntime().exec(toRun.toString(), null, installLocation.toFile());
        }
        catch (IOException e) {
            throw new Exception("Lanuching an app failed", e);
        }
    }
}

