/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.editor2;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.module.InvalidModulePathException;
import org.simantics.scl.compiler.module.ModuleUtils;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.editor.completion.SCLTextEditorEnvironment;
import org.simantics.scl.ui.editor2.OpenSCLDefinition;
import org.simantics.scl.ui.editor2.OpenSCLModule;
import org.simantics.scl.ui.editor2.SCLModuleEditor2;
import org.simantics.scl.ui.editor2.SCLModuleEditorInput;

public class OpenDeclaration
extends AbstractHandler {
    private static final String SYMBOL_CHARS = "!$%&*+/<=>?@\\^|-:~.";

    private static boolean isIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c) || c == '.';
    }

    private static String extractIdentifierAt(String text, int caretPos) {
        int startPos = caretPos;
        while (startPos > 0 && OpenDeclaration.isIdentifierPart(text.charAt(startPos - 1))) {
            --startPos;
        }
        int endPos = caretPos;
        while (endPos < text.length() && OpenDeclaration.isIdentifierPart(text.charAt(endPos))) {
            ++endPos;
        }
        return text.substring(startPos, endPos);
    }

    private static boolean isSymbolPart(char c) {
        int i = 0;
        while (i < SYMBOL_CHARS.length()) {
            if (SYMBOL_CHARS.charAt(i) == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String extractSymbolAt(String text, int caretPos) {
        int startPos = caretPos;
        while (startPos > 0 && OpenDeclaration.isSymbolPart(text.charAt(startPos - 1))) {
            --startPos;
        }
        int endPos = caretPos;
        while (endPos < text.length() && OpenDeclaration.isSymbolPart(text.charAt(endPos))) {
            ++endPos;
        }
        return text.substring(startPos, endPos);
    }

    public static String extractIdentifierOrSymbolAt(String text, int caretPos) {
        String result = OpenDeclaration.extractIdentifierAt(text, caretPos);
        if (!result.isEmpty()) {
            return result;
        }
        return OpenDeclaration.extractSymbolAt(text, caretPos);
    }

    private static String extractLineAt(String text, int caretPos) {
        int startPos = caretPos;
        while (startPos > 0 && !OpenDeclaration.isNewline(text.charAt(startPos - 1))) {
            --startPos;
        }
        int endPos = caretPos;
        while (endPos < text.length() && !OpenDeclaration.isNewline(text.charAt(endPos))) {
            ++endPos;
        }
        return text.substring(startPos, endPos);
    }

    private static boolean isNewline(char c) {
        return c == '\n' || c == '\r';
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        int caretOffset;
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (!(editor instanceof SCLModuleEditor2)) {
            return null;
        }
        SCLModuleEditor2 moduleEditor = (SCLModuleEditor2)editor;
        StyledText styledText = (StyledText)moduleEditor.getAdapter(Control.class);
        String text = styledText.getText();
        String lineAtCaret = OpenDeclaration.extractLineAt(text, caretOffset = styledText.getCaretOffset());
        if (lineAtCaret.startsWith("import ") || lineAtCaret.startsWith("include ")) {
            int p1 = lineAtCaret.indexOf(34, 6);
            int p2 = lineAtCaret.indexOf(34, p1 + 1);
            SCLModuleEditorInput input = (SCLModuleEditorInput)moduleEditor.getEditorInput();
            try {
                String moduleName = ModuleUtils.resolveAbsolutePath((String)input.getModuleName(), (String)lineAtCaret.substring(p1 + 1, p2));
                ModuleSource source = SCLOsgi.SOURCE_REPOSITORY.getModuleSource(moduleName, null);
                if (source != null) {
                    OpenSCLModule.openModule(moduleName);
                }
            }
            catch (InvalidModulePathException invalidModulePathException) {}
        } else {
            String identifierAtCaret = OpenDeclaration.extractIdentifierOrSymbolAt(text, caretOffset);
            if (identifierAtCaret.isEmpty()) {
                return null;
            }
            SCLTextEditorEnvironment editorEnvironment = moduleEditor.getSCLTextEditorEnvironment();
            editorEnvironment.updateEnvironment(moduleEditor.getDocument());
            SCLValue value = editorEnvironment.getValue(identifierAtCaret);
            System.out.println("identifierAtCaret = " + identifierAtCaret + " [" + Locations.beginOf((long)value.definitionLocation) + ", " + Locations.endOf((long)value.definitionLocation) + "]");
            if (value != null) {
                OpenSCLDefinition.openDefinition(value);
            }
        }
        return null;
    }
}

