/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.views.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWizard;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.ModelledAction;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.PossibleAdapter;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteInterface;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.ontology.ScenegraphResources;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.views.ontology.ViewsResources;
import org.simantics.views.swt.ModelledWizardPage;

public class ModelledWizard
extends Wizard
implements IWorkbenchWizard,
ModelledAction {
    final String configurationURI;
    private final ArrayList<IWizardPage> pages = new ArrayList();
    private final ArrayList<ModelledWizardPage> modelledPages = new ArrayList();
    private Function1<Object, Object> finishAction;
    private Resource runtime;

    public ModelledWizard(String configurationURI) {
        this.setNeedsProgressMonitor(true);
        this.configurationURI = configurationURI;
    }

    public List<ModelledWizardPage> getModelledPages() {
        return this.modelledPages;
    }

    public void addPages() {
        super.addPages();
        for (IWizardPage page : this.pages) {
            this.addPage(page);
        }
    }

    public boolean performFinish() {
        this.finishAction.apply((Object)this);
        return true;
    }

    public void loadPages(IWorkbenchSite site, ISessionContext context, WidgetSupport support) throws DatabaseException {
        this.runtime = (Resource)Simantics.getSession().sync((WriteInterface)new WriteResultRequest<Resource>((VirtualGraph)Simantics.getSession().getService(VirtualGraph.class)){

            public Resource perform(WriteGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                ScenegraphResources SG = ScenegraphResources.getInstance((ReadGraph)graph);
                Resource runtime = graph.newResource();
                graph.claim(runtime, L0.InstanceOf, null, SG.Runtime);
                return runtime;
            }
        });
        this.finishAction = (Function1)Simantics.getSession().syncRequest((Read)new Read<Function1<Object, Object>>(){

            public Function1<Object, Object> perform(ReadGraph graph) throws DatabaseException {
                ViewsResources VIEW = ViewsResources.getInstance((ReadGraph)graph);
                Resource configuration = graph.getResource(ModelledWizard.this.configurationURI);
                return (Function1)graph.getPossibleRelatedValue2(configuration, VIEW.Wizard_FinishAction);
            }
        });
        List pageResources = (List)Simantics.getSession().syncRequest((Read)new Read<List<Resource>>(){

            public List<Resource> perform(ReadGraph graph) throws DatabaseException {
                ViewsResources VIEW = ViewsResources.getInstance((ReadGraph)graph);
                Resource configuration = graph.getResource(ModelledWizard.this.configurationURI);
                Resource pageList = graph.getPossibleObject(configuration, VIEW.Wizard_Pages);
                if (pageList == null) {
                    return Collections.emptyList();
                }
                return ListUtils.toList((ReadGraph)graph, (Resource)pageList);
            }
        });
        for (Resource page : pageResources) {
            ModelledWizardPage p = (ModelledWizardPage)Simantics.getSession().syncRequest((AsyncRead)new PossibleAdapter(page, ModelledWizardPage.class));
            this.pages.add(p.create(context, support, this.runtime));
            this.modelledPages.add(p);
        }
    }

    public Runnable create(IWorkbenchSite site, ISessionContext context, WidgetSupport support) throws DatabaseException {
        List pageResources = (List)Simantics.getSession().syncRequest((Read)new Read<List<Resource>>(){

            public List<Resource> perform(ReadGraph graph) throws DatabaseException {
                ViewsResources VIEW = ViewsResources.getInstance((ReadGraph)graph);
                Resource configuration = graph.getResource(ModelledWizard.this.configurationURI);
                Resource pageList = graph.getPossibleObject(configuration, VIEW.Wizard_Pages);
                if (pageList == null) {
                    return Collections.emptyList();
                }
                return ListUtils.toList((ReadGraph)graph, (Resource)pageList);
            }
        });
        this.runtime = (Resource)Simantics.getSession().sync((WriteInterface)new WriteResultRequest<Resource>((VirtualGraph)Simantics.getSession().getService(VirtualGraph.class)){

            public Resource perform(WriteGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                ScenegraphResources SG = ScenegraphResources.getInstance((ReadGraph)graph);
                Resource runtime = graph.newResource();
                graph.claim(runtime, L0.InstanceOf, null, SG.Runtime);
                return runtime;
            }
        });
        for (Resource page : pageResources) {
            ModelledWizardPage p = (ModelledWizardPage)Simantics.getSession().syncRequest((AsyncRead)new PossibleAdapter(page, ModelledWizardPage.class));
            this.pages.add(p.create(context, support, this.runtime));
        }
        this.finishAction = (Function1)Simantics.getSession().syncRequest((Read)new Read<Function1<Object, Object>>(){

            public Function1<Object, Object> perform(ReadGraph graph) throws DatabaseException {
                ViewsResources VIEW = ViewsResources.getInstance((ReadGraph)graph);
                Resource configuration = graph.getResource(ModelledWizard.this.configurationURI);
                return (Function1)graph.getPossibleRelatedValue2(configuration, VIEW.Wizard_FinishAction);
            }
        });
        return null;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        WidgetSupportImpl support = new WidgetSupportImpl();
        try {
            this.loadPages(null, Simantics.getSessionContext(), (WidgetSupport)support);
            support.finish();
            support.fireInput(Simantics.getSessionContext(), (Object)selection);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }
}

