/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.graphical.layout;

public class BarnesHut {
    private static Bounds computeOctreeBounds(double[] posX, double[] posY) {
        double minX = posX[0];
        double minY = posY[0];
        double maxX = posX[0];
        double maxY = posY[0];
        int i = 1;
        while (i < posX.length) {
            double x = posX[i];
            double y = posY[i];
            if (x < minX) {
                minX = x;
            } else if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            } else if (y > maxY) {
                maxY = y;
            }
            ++i;
        }
        double diff = maxX - minX - (maxY - minY);
        if ((diff *= 0.5) > 0.0) {
            minY -= diff;
            maxY += diff;
        } else {
            minX += diff;
            maxX -= diff;
        }
        return new Bounds(minX, minY, maxX, maxY);
    }

    static class Bounds {
        final double minX;
        final double minY;
        final double maxX;
        final double maxY;

        public Bounds(double minX, double minY, double maxX, double maxY) {
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
        }
    }

    private static class VecRef {
        double x;
        double y;

        private VecRef() {
        }
    }
}

