/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.DefaultCopyHandler;
import org.simantics.db.layer0.util.TGConfigurer;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;

public class SharedOntologyCopyHandler
extends DefaultCopyHandler {
    public SharedOntologyCopyHandler(Resource resource) {
        super(resource);
    }

    public SharedOntologyCopyHandler(Collection<Resource> resources) {
        super(resources);
    }

    @Override
    protected TransferableGraphConfiguration2 createConfiguration(ReadGraph graph, boolean cut) throws DatabaseException {
        if (this.resources.size() != 1) {
            throw new DatabaseException("Assumed a single root");
        }
        Resource root = (Resource)this.resources.iterator().next();
        String uri = graph.getURI(root);
        List<TransferableGraphConfiguration2.RootSpec> roots = Collections.singletonList(new TransferableGraphConfiguration2.RootSpec(root, uri, true));
        return new TGConfigurer(graph, true, false).roots(roots).create();
    }
}

