/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.application.db;

import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.simantics.application.db.DatabaseHandle;
import org.simantics.application.db.IDatabaseHandle;
import org.simantics.db.Session;

public abstract class HeadlessDatabaseApplication
implements IApplication {
    private DatabaseHandle database;

    public Object start(IApplicationContext context) throws Exception {
        try {
            this.beforeConnect(context);
            this.connectToServer(context);
            this.afterConnect();
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            if (this.database != null) {
                try {
                    this.database.dispose();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public void stop() {
    }

    protected IDatabaseHandle connectToServer(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        this.database = new DatabaseHandle(args, this.deleteLocalCopyAtExit());
        return this.database;
    }

    protected Session getSession() {
        if (this.database == null) {
            throw new IllegalStateException("null database session");
        }
        return this.database.getSession();
    }

    protected void beforeConnect(IApplicationContext context) {
    }

    protected void afterConnect() {
    }

    protected boolean deleteLocalCopyAtExit() {
        return false;
    }
}

