/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.routing.algorithm1;

import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;
import org.simantics.g2d.routing.ConnectionDirectionUtil;
import org.simantics.g2d.routing.Terminal;
import org.simantics.g2d.routing.algorithm1.Direction;
import org.simantics.g2d.routing.algorithm1.Penalty;
import org.simantics.g2d.routing.algorithm1.PenaltyRectangle;
import org.simantics.g2d.routing.algorithm1.RoutePencil;
import org.simantics.g2d.routing.algorithm1.StopSet;

public class StaticRouter {
    StopSet[] stopSets = new StopSet[4];
    static final Comparator<RoutePencil> solutionComparator = new Comparator<RoutePencil>(){

        @Override
        public int compare(RoutePencil o1, RoutePencil o2) {
            double d2;
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1.penalty < o2.penalty) {
                return -1;
            }
            if (o1.penalty > o2.penalty) {
                return 1;
            }
            double d1 = o1.distance();
            if (d1 < (d2 = o2.distance())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    };

    public StaticRouter(Collection<PenaltyRectangle> rectangles) {
        int i = 0;
        while (i < 4) {
            Direction dir = Direction.directions[i];
            ArrayList<StopSet.Stop> stops = new ArrayList<StopSet.Stop>(rectangles.size());
            for (PenaltyRectangle rectangle : rectangles) {
                stops.add(new StopSet.Stop((i & 1) == 0 ? rectangle.xPenalty : rectangle.yPenalty, dir.minSide(rectangle), dir.maxSide(rectangle), dir.front(rectangle)));
            }
            this.stopSets[i] = new StopSet(stops);
            ++i;
        }
    }

    static double makeFinite(double x) {
        if (x == Double.POSITIVE_INFINITY) {
            return 10000.0;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return -10000.0;
        }
        return x;
    }

    public void addTargets(Collection<RoutePencil> targets, double x, double y, double minDist, int dirId) {
        Direction dir = Direction.directions[dirId];
        double side = dir.getSide(x, y);
        double dd = dir.getDir(x, y);
        this.stopSets[dirId].findStops(side, side, dd, new TargetFinder(dir, dd, side, 0.0, minDist, targets));
    }

    public Path2D route(Terminal begin, double[] points, Terminal end) {
        if (begin == null) {
            if (points.length < 2) {
                return null;
            }
            begin = new Terminal(points[0], points[1], 1, Terminal.ZEROS, null);
            points = Arrays.copyOfRange(points, 2, points.length);
        }
        if (end == null) {
            if (points.length < 2) {
                return null;
            }
            end = new Terminal(points[points.length - 2], points[points.length - 1], 15, Terminal.ZEROS, null);
            points = Arrays.copyOf(points, points.length - 2);
        }
        double dx = end.x - begin.x;
        double dy = end.y - begin.y;
        if (dx < begin.minDist[0] + end.minDist[2] + 20.0 && -dx < begin.minDist[2] + end.minDist[0] + 20.0 && dy < begin.minDist[1] + end.minDist[3] + 20.0 && -dy < begin.minDist[3] + end.minDist[1] + 20.0) {
            if ((begin.directions & 1) == 1 && (end.directions & 4) == 4 && dx > 0.0) {
                Path2D.Double path = new Path2D.Double();
                ((Path2D)path).moveTo(begin.x, begin.y);
                ((Path2D)path).lineTo(0.5 * (begin.x + end.x), begin.y);
                ((Path2D)path).lineTo(0.5 * (begin.x + end.x), end.y);
                ((Path2D)path).lineTo(end.x, end.y);
                return path;
            }
            if ((begin.directions & 4) == 4 && (end.directions & 1) == 1 && dx < 0.0) {
                Path2D.Double path = new Path2D.Double();
                ((Path2D)path).moveTo(begin.x, begin.y);
                ((Path2D)path).lineTo(0.5 * (begin.x + end.x), begin.y);
                ((Path2D)path).lineTo(0.5 * (begin.x + end.x), end.y);
                ((Path2D)path).lineTo(end.x, end.y);
                return path;
            }
            if ((begin.directions & 2) == 2 && (end.directions & 8) == 8 && dy > 0.0) {
                Path2D.Double path = new Path2D.Double();
                ((Path2D)path).moveTo(begin.x, begin.y);
                ((Path2D)path).lineTo(begin.x, 0.5 * (begin.y + end.y));
                ((Path2D)path).lineTo(end.x, 0.5 * (begin.y + end.y));
                ((Path2D)path).lineTo(end.x, end.y);
                return path;
            }
            if ((begin.directions & 8) == 8 && (end.directions & 2) == 2 && dy < 0.0) {
                Path2D.Double path = new Path2D.Double();
                ((Path2D)path).moveTo(begin.x, begin.y);
                ((Path2D)path).lineTo(begin.x, 0.5 * (begin.y + end.y));
                ((Path2D)path).lineTo(end.x, 0.5 * (begin.y + end.y));
                ((Path2D)path).lineTo(end.x, end.y);
                return path;
            }
        }
        SingleRoute oldRoute = null;
        int p = 0;
        while (p <= points.length) {
            int i;
            SingleRoute route;
            if (p == points.length) {
                ArrayList<RoutePencil> targets = new ArrayList<RoutePencil>(1);
                int i2 = 0;
                while (i2 < 4) {
                    if ((end.directions & 1 << i2) != 0) {
                        this.addTargets(targets, end.x, end.y, end.minDist[i2], i2);
                    }
                    ++i2;
                }
                route = new SingleRoute(end.x, end.y, targets.toArray(new RoutePencil[targets.size()]), ConnectionDirectionUtil.reverseDirections(end.directions), 1);
            } else {
                double x = points[p];
                double y = points[p + 1];
                ArrayList<RoutePencil> targets = new ArrayList<RoutePencil>(4);
                int i3 = 0;
                while (i3 < 4) {
                    this.addTargets(targets, x, y, 0.0, i3);
                    ++i3;
                }
                route = new SingleRoute(x, y, targets.toArray(new RoutePencil[targets.size()]), 15, 1);
            }
            if (oldRoute == null) {
                i = 0;
                while (i < 4) {
                    if ((begin.directions & 1 << i) != 0) {
                        Direction dir = Direction.directions[i];
                        double side = dir.getSide(begin.x, begin.y);
                        double dd = dir.getDir(begin.x, begin.y);
                        route.prime(dir, side, side, dd, begin.minDist[i]);
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < 4) {
                    if (oldRoute.solutions[i] != null) {
                        route.prime(oldRoute.solutions[i]);
                    }
                    ++i;
                }
            }
            route.solve();
            oldRoute = route;
            p += 2;
        }
        RoutePencil[] solutions = oldRoute.solutions;
        Arrays.sort(solutions, solutionComparator);
        if (solutions[0] == null) {
            return null;
        }
        return solutions[0].createPath(end.x, end.y);
    }

    static class Continuation
    implements Comparable<Continuation> {
        Direction direction;
        double min;
        double max;
        double front;
        StopSet.Line line;
        int pos;
        RoutePencil parent;
        double penalty;
        double minTurnDistance;
        double priority;
        double distance;

        public Continuation(Direction direction, double min, double max, double front, int pos, StopSet.Line line, RoutePencil parent, double penalty, double minTurnDistance, double targetX, double targetY) {
            this.direction = direction;
            this.min = min;
            this.max = max;
            this.front = front;
            this.pos = pos;
            this.line = line;
            this.parent = parent;
            this.penalty = penalty;
            this.minTurnDistance = minTurnDistance;
            this.calcDistance(targetX, targetY);
        }

        @Override
        public int compareTo(Continuation o) {
            if (this.priority < o.priority) {
                return -1;
            }
            if (this.priority > o.priority) {
                return 1;
            }
            if (this.distance < o.distance) {
                return -1;
            }
            if (this.distance > o.distance) {
                return 1;
            }
            return 0;
        }

        public int hashCode() {
            int result = this.direction.getId();
            long temp = Double.doubleToLongBits(this.front);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.max);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.min);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Continuation other = (Continuation)obj;
            if (this.direction == null ? other.direction != null : this.direction != other.direction) {
                return false;
            }
            if (Double.doubleToLongBits(this.front) != Double.doubleToLongBits(other.front)) {
                return false;
            }
            if (Double.doubleToLongBits(this.max) != Double.doubleToLongBits(other.max)) {
                return false;
            }
            return Double.doubleToLongBits(this.min) == Double.doubleToLongBits(other.min);
        }

        void calcDistance(double x, double y) {
            if (this.parent == null) {
                this.distance = 0.0;
            }
            this.distance = this.parent.distanceConstant;
            switch (this.direction.getId()) {
                case 0: {
                    this.distance = this.front > this.parent.x1 ? (this.distance += this.parent.distanceX * this.parent.x1 + (this.front - this.parent.x1)) : (this.distance += this.parent.distanceX * this.front);
                    this.distance += Math.abs(x - this.front);
                    if (y < this.min) {
                        this.distance += this.parent.distanceY * this.min + (this.min - y);
                        break;
                    }
                    if (y > this.max) {
                        this.distance += this.parent.distanceY * this.max + (y - this.max);
                        break;
                    }
                    this.distance += this.parent.distanceY * y;
                    break;
                }
                case 1: {
                    this.distance = this.front > this.parent.y1 ? (this.distance += this.parent.distanceY * this.parent.y1 + (this.front - this.parent.y1)) : (this.distance += this.parent.distanceY * this.front);
                    this.distance += Math.abs(y - this.front);
                    if (x < this.min) {
                        this.distance += this.parent.distanceX * this.min + (this.min - x);
                        break;
                    }
                    if (x > this.max) {
                        this.distance += this.parent.distanceX * this.max + (x - this.max);
                        break;
                    }
                    this.distance += this.parent.distanceX * x;
                    break;
                }
                case 2: {
                    this.distance = -this.front < this.parent.x0 ? (this.distance += this.parent.distanceX * this.parent.x0 + (this.parent.x0 + this.front)) : (this.distance += this.parent.distanceX * -this.front);
                    this.distance += Math.abs(x + this.front);
                    if (y < this.min) {
                        this.distance += this.parent.distanceY * this.min + (this.min - y);
                        break;
                    }
                    if (y > this.max) {
                        this.distance += this.parent.distanceY * this.max + (y - this.max);
                        break;
                    }
                    this.distance += this.parent.distanceY * y;
                    break;
                }
                case 3: {
                    this.distance = -this.front < this.parent.y0 ? (this.distance += this.parent.distanceY * this.parent.y0 + (this.parent.y0 + this.front)) : (this.distance += this.parent.distanceY * -this.front);
                    this.distance += Math.abs(y + this.front);
                    if (x < this.min) {
                        this.distance += this.parent.distanceX * this.min + (this.min - x);
                        break;
                    }
                    if (x > this.max) {
                        this.distance += this.parent.distanceX * this.max + (x - this.max);
                        break;
                    }
                    this.distance += this.parent.distanceX * x;
                }
            }
        }
    }

    static class Cost
    implements Comparable<Cost> {
        double penalty;
        double distance;

        public Cost(double penalty, double distance) {
            this.penalty = penalty;
            this.distance = distance;
        }

        @Override
        public int compareTo(Cost o) {
            if (this.penalty < o.penalty) {
                return -1;
            }
            if (this.penalty > o.penalty) {
                return 1;
            }
            if (this.distance < o.distance) {
                return -1;
            }
            if (this.distance > o.distance) {
                return 1;
            }
            return 0;
        }
    }

    class SingleRoute {
        PriorityQueue<Continuation> queue = new PriorityQueue();
        double targetX;
        double targetY;
        RoutePencil[] targets;
        int targetDirs;
        RoutePencil[] solutions = new RoutePencil[4];
        int requiredSolutionCount;
        double bPenalty = Double.POSITIVE_INFINITY;
        double bDistance = Double.POSITIVE_INFINITY;
        Cost[] sortedCosts = new Cost[4];
        HashMap<Continuation, Continuation> continuations = new HashMap();

        public SingleRoute(double targetX, double targetY, RoutePencil[] targets, int targetDirs, int requiredSolutionCount) {
            RoutePencil target;
            this.targetX = targetX;
            this.targetY = targetY;
            this.targets = targets;
            this.targetDirs = targetDirs;
            this.requiredSolutionCount = requiredSolutionCount;
            double minPenalty = Double.MAX_VALUE;
            RoutePencil[] routePencilArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                target = routePencilArray[n2];
                if (target.penalty < minPenalty) {
                    minPenalty = target.penalty;
                }
                ++n2;
            }
            if (minPenalty > 0.0) {
                routePencilArray = targets;
                n = targets.length;
                n2 = 0;
                while (n2 < n) {
                    target = routePencilArray[n2];
                    target.penalty -= minPenalty;
                    ++n2;
                }
            }
        }

        void calcPriority(Continuation cont) {
            cont.priority = cont.penalty;
            double tDir = cont.direction.getDir(this.targetX, this.targetY);
            double tSide = cont.direction.getSide(this.targetX, this.targetY);
            if (tDir >= cont.front) {
                if (tSide < cont.min || tSide > cont.max) {
                    cont.priority += 1.0;
                }
            } else {
                cont.priority += 2.0;
            }
        }

        void prime(Direction dir, double min, double max, double front, double minTurnDistance) {
            Continuation cont = new Continuation(dir, min, max, front, 0, null, dir.createPencil(front, front, min, max, 0.0, null), 0.0, minTurnDistance, this.targetX, this.targetY);
            this.addContinutation(cont);
        }

        void prime(RoutePencil pencil) {
            Direction dir = pencil.direction;
            Continuation cont = new Continuation(dir, dir.minSide(pencil), dir.maxSide(pencil), dir.back(pencil), 0, null, pencil, pencil.penalty, 0.0, this.targetX, this.targetY);
            this.addContinutation(cont);
        }

        void solve() {
            int count = 0;
            while (!this.queue.isEmpty() && count < 10000) {
                Continuation cont = (Continuation)this.queue.remove();
                if (cont.priority > this.bPenalty || cont.priority == this.bPenalty && cont.distance >= this.bDistance) {
                    return;
                }
                this.doContinuation(cont);
                ++count;
            }
        }

        void addContinutation(Continuation cont) {
            Continuation old = this.continuations.get(cont);
            if (old != null) {
                if (old.priority < cont.priority) {
                    return;
                }
                if (old.priority == cont.priority && old.distance <= cont.distance) {
                    return;
                }
            }
            this.continuations.put(cont, cont);
            this.calcPriority(cont);
            this.queue.add(cont);
        }

        void addBend(RoutePencil pencil) {
            boolean foundSolution = false;
            RoutePencil[] routePencilArray = this.targets;
            int n = this.targets.length;
            int n2 = 0;
            while (n2 < n) {
                int dir;
                RoutePencil target = routePencilArray[n2];
                if (pencil.intersects(target) && (dir = target.direction.getId()) != pencil.direction.getId()) {
                    double d2;
                    RoutePencil sol;
                    double d1;
                    dir = (dir + 2) % 4;
                    double penalty = pencil.penalty + target.penalty;
                    if (dir != pencil.direction.getId()) {
                        penalty += 1.0;
                    }
                    if (this.solutions[dir] == null || this.solutions[dir].penalty > penalty) {
                        this.solutions[dir] = new RoutePencil(this.targetX, this.targetY, this.targetX, this.targetY, penalty, Direction.directions[dir], pencil);
                        foundSolution = true;
                    } else if (this.solutions[dir].penalty == penalty && (d1 = (sol = new RoutePencil(this.targetX, this.targetY, this.targetX, this.targetY, penalty, Direction.directions[dir], pencil)).distance()) < (d2 = this.solutions[dir].distance())) {
                        this.solutions[dir] = sol;
                        foundSolution = true;
                    }
                }
                ++n2;
            }
            if (foundSolution) {
                int i = 0;
                while (i < 4) {
                    this.sortedCosts[i] = this.solutions[i] == null ? Penalty.INFINITE_COST : new Cost(this.solutions[i].penalty, this.solutions[i].distance());
                    ++i;
                }
                Arrays.sort(this.sortedCosts);
                this.bPenalty = this.sortedCosts[this.requiredSolutionCount - 1].penalty;
                this.bDistance = this.sortedCosts[this.requiredSolutionCount - 1].distance;
            } else {
                Direction right;
                Direction left = pencil.direction.turnLeft();
                double front = left.back(pencil);
                if (front < Double.POSITIVE_INFINITY) {
                    Continuation leftCont = new Continuation(left, left.minSide(pencil), left.maxSide(pencil), front, 0, null, pencil, pencil.penalty + 1.0, 0.0, this.targetX, this.targetY);
                    this.addContinutation(leftCont);
                }
                if ((front = (right = pencil.direction.turnRight()).back(pencil)) < Double.POSITIVE_INFINITY) {
                    Continuation rightCont = new Continuation(right, right.minSide(pencil), right.maxSide(pencil), right.back(pencil), 0, null, pencil, pencil.penalty + 1.0, 0.0, this.targetX, this.targetY);
                    this.addContinutation(rightCont);
                }
            }
        }

        void doContinuation(final Continuation cont) {
            StopSet.IStopProcedure proc = new StopSet.IStopProcedure(){

                @Override
                public void blockEnd(double y) {
                    double front = cont.front + cont.minTurnDistance;
                    if (front <= y) {
                        SingleRoute.this.addBend(cont.direction.createPencil(front, y, cont.min, cont.max, cont.penalty, cont.parent));
                    }
                }

                @Override
                public void continuation(double min, double max, int pos, StopSet.Line line) {
                    double newMinTurnDistance;
                    double newPenalty = cont.penalty;
                    Penalty penalty = line.penalty[pos];
                    if (penalty != null) {
                        newPenalty += penalty.penalty;
                        newMinTurnDistance = Math.max(penalty.minDistance, cont.minTurnDistance - line.y + cont.front);
                    } else {
                        newMinTurnDistance = Math.max(0.0, cont.minTurnDistance - line.y + cont.front);
                    }
                    Continuation newCont = new Continuation(cont.direction, min, max, line.y, pos, line, cont.parent, newPenalty, newMinTurnDistance, SingleRoute.this.targetX, SingleRoute.this.targetY);
                    SingleRoute.this.addContinutation(newCont);
                }
            };
            if (cont.line != null) {
                StopSet.continueStop(cont.pos, cont.line, cont.min, cont.max, proc);
            } else {
                StopSet ss = StaticRouter.this.stopSets[cont.direction.getId()];
                ss.findStops(cont.min, cont.max, cont.front, proc);
            }
        }
    }

    class TargetFinder
    implements StopSet.IStopProcedure {
        Collection<RoutePencil> targets;
        Direction dir;
        double dd;
        double side;
        double penalty;
        double minDistance;

        public TargetFinder(Direction dir, double dd, double side, double penalty, double minDistance, Collection<RoutePencil> targets) {
            this.dd = dd;
            this.dir = dir;
            this.side = side;
            this.targets = targets;
            this.penalty = penalty;
            this.minDistance = minDistance;
        }

        @Override
        public void blockEnd(double y) {
            if (y >= this.dd + this.minDistance) {
                this.targets.add(this.dir.createPencil(this.dd + this.minDistance, y, this.side, this.side, this.penalty, null));
            }
        }

        @Override
        public void continuation(double min, double max, int pos, StopSet.Line line) {
            Penalty p = line.penalty[pos];
            if (p.penalty >= Penalty.OBSTACLE_PENALTY.penalty) {
                return;
            }
            StopSet.continueStop(pos, line, this.side, this.side, new TargetFinder(this.dir, line.y, this.side, Math.max(p.minDistance, this.minDistance - line.y + this.dd), this.penalty + p.penalty, this.targets));
        }
    }
}

