/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.commands.internal.checker;

import org.simantics.scl.commands.internal.checker.BooleanCheckItem;
import org.simantics.scl.commands.internal.checker.CheckItem;
import org.simantics.scl.commands.internal.checker.FunctionCheckItem;
import org.simantics.scl.commands.internal.checker.MaybeCheckItem;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.top.ValueNotFound;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.util.MultiFunction;
import org.simantics.scl.osgi.SCLOsgi;

public class Checker {
    Object check;
    CheckItem item;

    private Checker(Object check, CheckItem item) {
        this.check = check;
        this.item = item;
    }

    public boolean check(Object[] parameters) {
        return this.item.check(this.check, parameters, 0);
    }

    private static CheckItem checkItemForType(Type type) throws MatchException {
        if (type == Types.BOOLEAN) {
            return BooleanCheckItem.INSTANCE;
        }
        if (Types.isFunction((Type)type)) {
            MultiFunction mfun = Types.matchFunction((Type)type, (int)1);
            return new FunctionCheckItem(mfun.parameterTypes[0], Checker.checkItemForType(mfun.returnType));
        }
        if (Types.isApply((Type)Types.MAYBE, (int)1, (Type)type)) {
            Type componentType = Types.matchApply((TCon)Types.MAYBE, (Type)type);
            return new MaybeCheckItem(Checker.checkItemForType(componentType));
        }
        throw new MatchException();
    }

    public static Checker create(String name) {
        try {
            SCLValue checkRef = SCLOsgi.MODULE_REPOSITORY.getValueRef(name);
            Object check = SCLOsgi.MODULE_REPOSITORY.getValue(name);
            return new Checker(check, Checker.checkItemForType(checkRef.getType()));
        }
        catch (ValueNotFound valueNotFound) {
            return new Checker(Boolean.TRUE, BooleanCheckItem.INSTANCE);
        }
        catch (MatchException e) {
            e.printStackTrace();
            return new Checker(Boolean.FALSE, BooleanCheckItem.INSTANCE);
        }
    }
}

