/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.scl;

import gnu.trove.map.hash.THashMap;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.Environments;
import org.simantics.scl.compiler.top.SCLExpressionCompilationException;
import org.simantics.scl.compiler.types.Type;
import org.simantics.structural2.scl.ComponentTypeProperty;

public class ReadComponentTypeInterfaceRequest
extends ResourceRead<Map<String, ComponentTypeProperty>> {
    Environment environment;

    public ReadComponentTypeInterfaceRequest(Resource resource, Environment environment) {
        super(resource);
        this.environment = environment;
    }

    private void collect(ReadGraph graph, Resource t, THashMap<String, ComponentTypeProperty> result) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Map domain = Layer0Utils.getDomainOf((ReadGraph)graph, (Resource)t);
        for (Map.Entry entry : domain.entrySet()) {
            Type type;
            String typeName;
            String name = (String)entry.getKey();
            Resource relation = (Resource)entry.getValue();
            if (!graph.isSubrelationOf(relation, L0.HasProperty) || (typeName = (String)graph.getPossibleRelatedValue(relation, L0.RequiresValueType, (Binding)Bindings.STRING)) == null) continue;
            try {
                type = Environments.getType((Environment)this.environment, (String)typeName);
            }
            catch (SCLExpressionCompilationException e) {
                e.printStackTrace();
                continue;
            }
            ComponentTypeProperty property = new ComponentTypeProperty(relation, type);
            result.put((Object)name, (Object)property);
        }
    }

    public Map<String, ComponentTypeProperty> perform(ReadGraph graph) throws DatabaseException {
        THashMap result = new THashMap();
        this.collect(graph, this.resource, (THashMap<String, ComponentTypeProperty>)result);
        return result;
    }
}

