/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.DatatypeConstructionException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.issue.StandardIssue;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.function.All;
import org.simantics.db.layer0.function.StandardChildDomainChildren;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.AbstractChildVariable;
import org.simantics.db.layer0.variable.AbstractPropertyVariable;
import org.simantics.db.layer0.variable.LazyPropertyVariable;
import org.simantics.db.layer0.variable.NodeSupport;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.StandardGraphPropertyVariable;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.ValueAccessorWithBinding;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableMap;
import org.simantics.db.layer0.variable.VariableMapImpl;
import org.simantics.db.layer0.variable.VariableNode;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.issues.common.IssueUtils;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.simulator.variable.NodeManager;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.procedural.Component;
import org.simantics.structural2.procedural.ConnectionPoint;
import org.simantics.structural2.procedural.Interface;
import org.simantics.structural2.procedural.SubstructureElement;
import org.simantics.structural2.procedural.Terminal;
import org.simantics.structural2.queries.ConnectionComponents;
import org.simantics.structural2.queries.ConnectionJoinComponents;
import org.simantics.structural2.queries.ConnectionPointMapOfResource;
import org.simantics.structural2.queries.PossibleConnectionPointInfo;
import org.simantics.structural2.scl.CompileStructuralValueRequest;
import org.simantics.structural2.scl.procedural.CompileProceduralComponentTypeRequest;
import org.simantics.structural2.variables.Connection;
import org.simantics.structural2.variables.ConnectionBrowser;
import org.simantics.structural2.variables.StandardProceduralChildVariable;
import org.simantics.structural2.variables.VariableConnectionPointDescriptor;
import org.simantics.utils.datastructures.MapList;

public class Functions {
    @SCLValue(type="ValueAccessor")
    public static final ValueAccessor expressionValueAccessor = new ValueAccessorWithBinding(){

        public Binding getBinding() {
            return Bindings.STRING;
        }

        public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
            if (value == null) {
                if (this.getValue((ReadGraph)graph, context) != null) {
                    this.clearExpression(graph, context);
                }
                return;
            }
            String expression = (String)value;
            Variable parent = context.getParent((ReadGraph)graph);
            if (!(parent instanceof AbstractPropertyVariable)) {
                return;
            }
            AbstractPropertyVariable property = (AbstractPropertyVariable)parent;
            Resource propertyResource = property.getRepresents((ReadGraph)graph);
            if (propertyResource == null) {
                return;
            }
            Resource container = property.getContainerResource((ReadGraph)graph);
            if (container == null) {
                return;
            }
            Resource predicate = property.getPossiblePredicateResource((ReadGraph)graph);
            if (predicate == null) {
                return;
            }
            Statement stat = graph.getPossibleStatement(container, predicate);
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            boolean createNew = false;
            if (stat.isAsserted(container)) {
                createNew = true;
            } else if (!graph.isInstanceOf(propertyResource, STR.SCLValue)) {
                graph.deny(propertyResource);
                createNew = true;
            }
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            if (createNew) {
                propertyResource = graph.newResource();
                graph.claim(container, predicate, propertyResource);
                graph.claim(propertyResource, L0.InstanceOf, STR.SCLValue);
            }
            graph.claimLiteral(propertyResource, L0.SCLValue_expression, (Object)expression, (Binding)Bindings.STRING);
        }

        private void clearExpression(WriteGraph graph, Variable context) throws DatabaseException {
            Variable parent = context.getParent((ReadGraph)graph);
            if (!(parent instanceof AbstractPropertyVariable)) {
                return;
            }
            AbstractPropertyVariable property = (AbstractPropertyVariable)parent;
            Resource container = property.getContainerResource((ReadGraph)graph);
            if (container == null) {
                return;
            }
            Resource predicate = property.getPossiblePredicateResource((ReadGraph)graph);
            if (predicate == null) {
                return;
            }
            graph.deny(container, predicate);
        }

        public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
            Variable parent = context.getParent(graph);
            if (!(parent instanceof AbstractPropertyVariable)) {
                return null;
            }
            AbstractPropertyVariable property = (AbstractPropertyVariable)parent;
            Resource propertyResource = property.getPossibleRepresents(graph);
            if (propertyResource == null) {
                return null;
            }
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            if (!graph.isInstanceOf(propertyResource, STR.SCLValue)) {
                return null;
            }
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            return graph.getPossibleRelatedValue(propertyResource, L0.SCLValue_expression);
        }
    };
    @SCLValue(type="ValueAccessor")
    public static final ValueAccessor connectionValueAccessor = new ValueAccessor(){

        public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
            throw new UnsupportedOperationException();
        }

        public void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException {
            throw new UnsupportedOperationException();
        }

        public Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
            try {
                Object value = this.getValue(graph, context);
                Binding srcBinding = Bindings.OBJECT.getContentBinding(value);
                return Bindings.adapt((Object)value, (Binding)srcBinding, (Binding)binding);
            }
            catch (AdaptException e) {
                throw new DatabaseException((Throwable)e);
            }
            catch (BindingException e) {
                throw new DatabaseException((Throwable)e);
            }
        }

        public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
            StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
            return new ConnectionImpl(variable);
        }

        public Datatype getDatatype(ReadGraph graph, Variable context) throws DatabaseException {
            try {
                return Datatypes.getDatatype(Connection.class);
            }
            catch (DatatypeConstructionException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap structuralChildDomainProperties = new VariableMapImpl(){

        public Variable getPossibleConnectionPointFromContext(ReadGraph graph, Variable variable, Resource context, String name) throws DatabaseException {
            Map connectionPoints = (Map)graph.syncRequest((Read)new ConnectionPointMapOfResource(graph, context), (AsyncProcedure)TransientCacheAsyncListener.instance());
            Resource cp = (Resource)connectionPoints.get(name);
            if (cp == null) {
                return null;
            }
            return new StandardGraphPropertyVariable(graph, variable, cp);
        }

        public Map<String, Variable> collectConnectionPointsFromContext(ReadGraph graph, StructuralResource2 STR, Variable variable, Resource context, Map<String, Variable> map, boolean needSynchronized) throws DatabaseException {
            if (graph.isImmutable(context)) {
                Map cps = (Map)graph.syncRequest((Read)new ConnectionPointMapOfResource(graph, context), (AsyncProcedure)TransientCacheAsyncListener.instance());
                if (cps.size() == 0) {
                    return map;
                }
                if (map == null) {
                    map = new THashMap(cps.size());
                }
                for (Map.Entry entry : cps.entrySet()) {
                    String name = (String)entry.getKey();
                    Resource cp = (Resource)entry.getValue();
                    if (needSynchronized && !graph.isInstanceOf(cp, STR.SynchronizedConnectionRelation)) continue;
                    map.put(name, new StandardGraphPropertyVariable(graph, variable, cp));
                }
                return map;
            }
            Collection predicates = graph.getPredicates(context);
            for (Resource predicate : predicates) {
                PropertyInfo info;
                PropertyInfo propertyInfo = info = graph.isImmutable(predicate) ? (PropertyInfo)graph.syncRequest((Read)new PossibleConnectionPointInfo(predicate), (AsyncProcedure)TransientCacheAsyncListener.instance()) : (PropertyInfo)graph.syncRequest((Read)new PossibleConnectionPointInfo(predicate));
                if (info == null) continue;
                if (map == null) {
                    map = new THashMap(4);
                }
                if (needSynchronized && !graph.isInstanceOf(predicate, STR.SynchronizedConnectionRelation)) continue;
                map.put(info.name, new StandardGraphPropertyVariable(graph, variable, predicate));
            }
            return map;
        }

        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
            Variable cp = this.getPossibleConnectionPointFromContext(graph, (Variable)variable, variable.resource, name);
            if (cp != null) {
                return cp;
            }
            return All.getStandardChildDomainPropertyVariable((ReadGraph)graph, (Variable)context, (String)name);
        }

        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            map = this.collectConnectionPointsFromContext(graph, STR, (Variable)variable, variable.resource, map, false);
            return All.getStandardChildDomainPropertyVariables((ReadGraph)graph, (Variable)context, map);
        }

        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, String classification, Map<String, Variable> map) throws DatabaseException {
            if ("http://www.simantics.org/Structural-1.2/SynchronizedRelation".equals(classification)) {
                return All.getStandardChildDomainPropertyVariables((ReadGraph)graph, (Variable)context, (String)classification, map);
            }
            if ("http://www.simantics.org/Structural-1.2/SynchronizedConnectionRelation".equals(classification)) {
                StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
                return this.collectConnectionPointsFromContext(graph, StructuralResource2.getInstance((ReadGraph)graph), (Variable)variable, variable.resource, map, true);
            }
            if ("http://www.simantics.org/Structural-1.2/ConnectionRelation".equals(classification)) {
                StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
                return this.collectConnectionPointsFromContext(graph, StructuralResource2.getInstance((ReadGraph)graph), (Variable)variable, variable.resource, map, false);
            }
            return super.getVariables(graph, context, classification, map);
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap structuralChildDomainChildren = new VariableMapImpl(){

        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            Map children;
            Resource represents;
            Resource type = context.getPossibleType(graph);
            if (type != null) {
                Map map;
                StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                if (graph.isInstanceOf(type, STR.ProceduralComponentType) && (map = (Map)graph.syncRequest((Read)new ProceduralSubstructureRequest(context), (Listener)TransientCacheListener.instance())) != null) {
                    return (Variable)map.get(name);
                }
            }
            if ((represents = context.getPossibleRepresents(graph)) == null) {
                children = (Map)graph.syncRequest((Read)new StructuralChildMapOfResourceT(type));
                Resource child = (Resource)children.get(name);
                return All.getStandardChildDomainChildVariable((ReadGraph)graph, (Variable)context, (Resource)child, (String)name);
            }
            children = (Map)graph.syncRequest((Read)new StructuralChildMapOfResource(represents));
            Resource child = (Resource)children.get(name);
            return All.getStandardChildDomainChildVariable((ReadGraph)graph, (Variable)context, (Resource)child, (String)name);
        }

        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            Map children;
            Resource represents;
            Resource type = context.getPossibleType(graph);
            if (type != null) {
                Map mapPrime;
                StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                if (graph.isInstanceOf(type, STR.ProceduralComponentType) && (mapPrime = (Map)graph.syncRequest((Read)new ProceduralSubstructureRequest(context), (Listener)TransientCacheListener.instance())) != null) {
                    if (map != null) {
                        map.putAll(mapPrime);
                        return map;
                    }
                    return mapPrime;
                }
            }
            if ((represents = context.getPossibleRepresents(graph)) == null) {
                children = (Map)graph.syncRequest((Read)new StructuralChildMapOfResourceT(type));
                return StandardChildDomainChildren.getStandardChildDomainChildVariables((ReadGraph)graph, (Variable)context, (Map)children, map);
            }
            children = (Map)graph.syncRequest((Read)new StructuralChildMapOfResource(represents));
            return StandardChildDomainChildren.getStandardChildDomainChildVariables((ReadGraph)graph, (Variable)context, (Map)children, map);
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap structuralRunDomainChildren = new VariableMapImpl(){

        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            Map children = (Map)graph.syncRequest((Read)new StructuralRunChildMapOfResource(context.getRepresents(graph)));
            Resource child = (Resource)children.get(name);
            return StandardChildDomainChildren.getStandardChildDomainChildVariable((ReadGraph)graph, (Variable)context, (Resource)child, (String)name);
        }

        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
            Map children = (Map)graph.syncRequest((Read)new StructuralRunChildMapOfResource(variable.resource));
            return StandardChildDomainChildren.getStandardChildDomainChildVariables((ReadGraph)graph, (Variable)context, (Map)children, map);
        }
    };
    public static final Collection<InterfaceResolution> BUILTIN_STRUCTURAL_CPS = new ArrayList<InterfaceResolution>();

    public static List<SubstructureElement> getProceduralDesc(ReadGraph graph, Variable context) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource type = context.getPossibleType(graph);
        if (type != null && graph.isInstanceOf(type, STR.ProceduralComponentType)) {
            return (List)graph.syncRequest((Read)new SubstructureRequest(context));
        }
        return null;
    }

    public static Map<String, Variable> getProcedural(ReadGraph graph, Variable context, List<SubstructureElement> elements, Map<String, Variable> map) throws DatabaseException {
        if (map == null) {
            map = new THashMap();
        }
        MapList conns = new MapList();
        for (SubstructureElement sub : elements) {
            if (!(sub instanceof org.simantics.structural2.procedural.Connection)) continue;
            org.simantics.structural2.procedural.Connection conn = (org.simantics.structural2.procedural.Connection)sub;
            for (ConnectionPoint connectionPoint : conn.connectionPoints) {
                if (!(connectionPoint instanceof Terminal)) continue;
                Terminal t = (Terminal)connectionPoint;
                conns.add((Object)t.component, (Object)conn);
            }
        }
        THashMap proceduralChildren = new THashMap();
        for (SubstructureElement sub : elements) {
            if (!(sub instanceof Component)) continue;
            Component component = (Component)sub;
            proceduralChildren.put(component.name, component);
        }
        Collection nodeChildren = All.getPossibleNodeChildren((ReadGraph)graph, (Variable)((AbstractChildVariable)context));
        HashSet<String> used = new HashSet<String>(nodeChildren.size());
        for (ConnectionPoint connectionPoint : nodeChildren) {
            NodeSupport support = ((AbstractChildVariable)context).node.support;
            NodeManager manager = support.manager;
            String name = manager.getName((Object)connectionPoint);
            used.add(name);
            Component proceduralChild = (Component)proceduralChildren.get(name);
            if (proceduralChild == null) continue;
            map.put(proceduralChild.name, new StandardProceduralChildVariable(graph, context, new VariableNode(support, (Object)connectionPoint), proceduralChild.name, proceduralChild.type, proceduralChild.properties, conns.getValues((Object)proceduralChild.name)));
        }
        for (Map.Entry entry : proceduralChildren.entrySet()) {
            String name = (String)entry.getKey();
            if (used.contains(name)) continue;
            Component proceduralChild = (Component)entry.getValue();
            map.put(proceduralChild.name, new StandardProceduralChildVariable(graph, context, null, proceduralChild.name, proceduralChild.type, proceduralChild.properties, conns.getValues((Object)proceduralChild.name)));
        }
        return map;
    }

    @SCLValue(type="ReadGraph -> [Resource] -> [Resource]")
    public static List<Resource> connectionExtension(ReadGraph graph, List<Resource> rs) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        HashSet extension = new HashSet(8);
        for (Resource r : rs) {
            if (graph.isInstanceOf(r, STR.Connection)) {
                extension.addAll((Collection)graph.syncRequest((Read)new ConnectionComponents(r), (Listener)TransientCacheListener.instance()));
            }
            if (!graph.isInstanceOf(r, STR.ConnectionJoin)) continue;
            extension.addAll((Collection)graph.syncRequest((Read)new ConnectionJoinComponents(r), (Listener)TransientCacheListener.instance()));
        }
        HashSet components = new HashSet(8);
        for (Resource r : extension) {
            components.addAll((Collection)graph.sync((ReadInterface)new ObjectsWithType(r, STR.Connects, STR.Component)));
        }
        if (!extension.isEmpty()) {
            ArrayList<Resource> result = new ArrayList<Resource>(rs.size() + extension.size());
            result.addAll(rs);
            result.addAll(extension);
            result.addAll(components);
            rs = result;
        }
        return rs;
    }

    @SCLValue(type="ReadGraph -> Resource -> [Issue]")
    public static List<Issue> connectionValidator(ReadGraph graph, Resource component) throws DatabaseException {
        if (!graph.hasStatement(component)) {
            return Collections.emptyList();
        }
        ArrayList<Issue> result = new ArrayList<Issue>();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)graph);
        Resource type = graph.getSingleType(component, sr.Component);
        HashSet<Resource> requiredConnections = new HashSet<Resource>();
        for (Resource connectionRelation : (Collection)graph.sync((ReadInterface)new ObjectsWithType(type, L0.ConsistsOf, sr.ConnectionRelation))) {
            Boolean required = (Boolean)graph.getPossibleRelatedValue(connectionRelation, sr.ConnectionRelation_connectionRequired, (Binding)Bindings.BOOLEAN);
            if (required == null || !required.booleanValue()) continue;
            requiredConnections.add(connectionRelation);
        }
        HashSet<Resource> connections = new HashSet<Resource>();
        for (Statement stm : graph.getStatements(component, sr.IsConnectedTo)) {
            connections.add(stm.getPredicate());
            connections.addAll(graph.getSuperrelations(stm.getPredicate()));
        }
        for (Resource req : requiredConnections) {
            if (connections.contains(req)) continue;
            result.add((Issue)new StandardIssue(sr.ConnectionConstraint_ErrorIssue, new Resource[]{component, req}));
        }
        return result;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String connectionIssueDescription(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        List contexts = IssueUtils.getContextsForProperty((ReadGraph)graph, (Variable)property);
        String attributeName = (String)graph.getRelatedValue((Resource)contexts.get(1), Layer0.getInstance((ReadGraph)graph).HasName);
        return "'" + attributeName + "' should be connected.";
    }

    public static String resolveInterfacePath(ReadGraph graph, Variable context, String component, Resource relation) throws DatabaseException {
        GraphMap map = (GraphMap)graph.syncRequest((Read)new InterfacePathMap(context), (Listener)TransientCacheListener.instance());
        Map childMap = (Map)map.get(graph, component);
        if (childMap == null) {
            return "";
        }
        PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(relation), (Listener)TransientCacheListener.instance());
        InterfaceResolution match = (InterfaceResolution)childMap.get(info.name);
        if (match != null) {
            String comp = URIStringUtils.escape((String)component);
            Variable newContext = context.getChild(graph, component);
            return "/" + comp + Functions.resolveInterfacePath(graph, newContext, match.componentName, match.connectionPoint);
        }
        return "/" + URIStringUtils.escape((String)component) + "#" + URIStringUtils.escape((String)info.name);
    }

    public static Collection<InterfaceResolution> computeInterfacePaths(ReadGraph graph, Variable variable) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource type = variable.getPossibleType(graph);
        if (type != null) {
            if (graph.isInstanceOf(type, STR.ProceduralComponentType)) {
                ArrayList<InterfaceResolution> result = new ArrayList<InterfaceResolution>();
                List<SubstructureElement> elements = Functions.getProceduralDesc(graph, variable);
                if (elements != null) {
                    for (SubstructureElement e : elements) {
                        if (!(e instanceof org.simantics.structural2.procedural.Connection)) continue;
                        org.simantics.structural2.procedural.Connection conn = (org.simantics.structural2.procedural.Connection)e;
                        Interface inf = null;
                        for (ConnectionPoint cp : conn.connectionPoints) {
                            if (!(cp instanceof Interface)) continue;
                            if (inf != null) {
                                throw new DatabaseException("Multiple interfaces referenced in procedural connection.");
                            }
                            inf = (Interface)cp;
                        }
                        if (inf == null || conn.connectionPoints.size() <= 1) continue;
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        String cpName = URIStringUtils.escape((String)((String)graph.getRelatedValue(inf.relation, L0.HasName, (Binding)Bindings.STRING)));
                        for (ConnectionPoint cp : conn.connectionPoints) {
                            if (cp == inf) continue;
                            Terminal t = (Terminal)cp;
                            result.add(new InterfaceResolution(inf.relation, cpName, t.component, t.relation));
                        }
                    }
                }
                return result;
            }
            Collection interfaces = (Collection)graph.syncRequest((Read)new DefinedUCInterfaceMap(type));
            if (interfaces != null) {
                return interfaces;
            }
        }
        return BUILTIN_STRUCTURAL_CPS;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object computeExpression(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return CompileStructuralValueRequest.compileAndEvaluate(graph, context);
    }

    public static Object computeExpressionInContext(ReadGraph graph, Variable context, final String expression) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get((Object)"graph");
        try {
            Function1 exp = (Function1)graph.syncRequest((Read)new CompileStructuralValueRequest(graph, context){

                @Override
                protected String getExpressionText(ReadGraph graph) throws DatabaseException {
                    return expression;
                }
            }, (Listener)TransientCacheListener.instance());
            sclContext.put((Object)"graph", (Object)graph);
            Object object = exp.apply((Object)context);
            return object;
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new DatabaseException(t);
        }
        finally {
            sclContext.put((Object)"graph", oldGraph);
        }
    }

    static class ConnectionImpl
    implements Connection {
        private final StandardGraphPropertyVariable connectionPoint;

        public ConnectionImpl(StandardGraphPropertyVariable connectionPoint) {
            this.connectionPoint = connectionPoint;
        }

        @Override
        public Collection<Variable> getConnectionPoints(ReadGraph graph, Resource relationType) throws DatabaseException {
            THashSet result = new THashSet();
            for (VariableConnectionPointDescriptor desc : ConnectionBrowser.flatten(graph, this.connectionPoint.parent, this.connectionPoint.property.predicate, relationType)) {
                result.add(desc.getVariable(graph));
            }
            return result;
        }

        @Override
        public Collection<String> getConnectionPointURIs(ReadGraph graph, Resource relationType) throws DatabaseException {
            THashSet result = new THashSet();
            for (VariableConnectionPointDescriptor desc : ConnectionBrowser.flatten(graph, this.connectionPoint.parent, this.connectionPoint.property.predicate, relationType)) {
                result.add(desc.getURI(graph));
            }
            return result;
        }

        @Override
        public Collection<VariableConnectionPointDescriptor> getConnectionPointDescriptors(ReadGraph graph, Resource relationType) throws DatabaseException {
            return ConnectionBrowser.flatten(graph, this.connectionPoint.parent, this.connectionPoint.property.predicate, relationType);
        }
    }

    static class DefinedUCInterfaceMap
    extends ResourceRead<Collection<InterfaceResolution>> {
        public DefinedUCInterfaceMap(Resource resource) {
            super(resource);
        }

        public Collection<InterfaceResolution> perform(ReadGraph graph) throws DatabaseException {
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            Resource definition = graph.getPossibleObject(this.resource, STR.IsDefinedBy);
            if (definition != null) {
                ArrayList<InterfaceResolution> result = new ArrayList<InterfaceResolution>();
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                for (Resource cp : (Collection)graph.syncRequest((Read)new ObjectsWithType(this.resource, L0.ConsistsOf, STR.ConnectionRelation))) {
                    String cpName = (String)graph.getRelatedValue(cp, L0.HasName, (Binding)Bindings.STRING);
                    for (Resource conn : graph.getObjects(cp, STR.IsBoundBy)) {
                        Statement stm = graph.getPossibleStatement(conn, STR.Connects);
                        if (stm == null) continue;
                        Resource component = stm.getObject();
                        String componentName = (String)graph.getRelatedValue(component, L0.HasName, (Binding)Bindings.STRING);
                        result.add(new InterfaceResolution(cp, cpName, componentName, graph.getInverse(stm.getPredicate())));
                    }
                }
                return result;
            }
            return null;
        }
    }

    static abstract class GraphMap<Value> {
        GraphMap() {
        }

        abstract Value get(ReadGraph var1, String var2) throws DatabaseException;
    }

    public static class InterfacePathMap
    extends VariableRead<GraphMap<Map<String, InterfaceResolution>>> {
        public InterfacePathMap(Variable context) {
            super(context);
        }

        public GraphMap<Map<String, InterfaceResolution>> perform(ReadGraph graph) throws DatabaseException {
            return new GraphMap<Map<String, InterfaceResolution>>(){

                @Override
                Map<String, InterfaceResolution> get(ReadGraph graph, String key) throws DatabaseException {
                    Variable child = variable.getChild(graph, key);
                    THashMap childMap = new THashMap();
                    Collection<InterfaceResolution> paths = Functions.computeInterfacePaths(graph, child);
                    if (paths != null) {
                        for (InterfaceResolution r : paths) {
                            childMap.put(r.interfaceName, r);
                        }
                    }
                    return childMap;
                }
            };
        }
    }

    static abstract class InterfacePathProperty
    extends LazyPropertyVariable {
        public InterfacePathProperty(Variable parent) {
            super(parent, "proceduralConnectionPointPath", (Binding)Bindings.STRING_ARRAY);
        }

        public <T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException {
            return (T)this.getValue(graph);
        }
    }

    static class InterfacePathRequest
    extends VariableRead<Collection<InterfaceResolution>> {
        public InterfacePathRequest(Variable variable) {
            super(variable);
        }

        public Collection<InterfaceResolution> perform(ReadGraph graph) throws DatabaseException {
            return Functions.computeInterfacePaths(graph, this.variable);
        }
    }

    public static class InterfaceResolution {
        public Resource interfaceConnectionPoint;
        public String interfaceName;
        public String componentName;
        public Resource connectionPoint;

        public InterfaceResolution(Resource interfaceConnectionPoint, String interfaceName, String componentName, Resource connectionPoint) {
            this.interfaceConnectionPoint = interfaceConnectionPoint;
            this.interfaceName = interfaceName;
            this.componentName = componentName;
            this.connectionPoint = connectionPoint;
        }
    }

    private static class ProceduralSubstructureRequest
    extends VariableRead<Map<String, Variable>> {
        public ProceduralSubstructureRequest(Variable variable) {
            super(variable);
        }

        public Map<String, Variable> perform(ReadGraph graph) throws DatabaseException {
            List<SubstructureElement> elements = Functions.getProceduralDesc(graph, this.variable);
            if (elements != null) {
                return Functions.getProcedural(graph, this.variable, elements, null);
            }
            return null;
        }
    }

    static class StructuralChildMapOfResource
    extends ResourceRead<Map<String, Resource>> {
        public StructuralChildMapOfResource(Resource resource) {
            super(resource);
        }

        public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {
            Map map;
            Resource definition;
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            Resource type = graph.getPossibleType(this.resource, STR.Component);
            if (type != null && (definition = graph.getPossibleObject(type, STR.IsDefinedBy)) != null && !(map = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(definition))).isEmpty()) {
                return map;
            }
            Map directChildren = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(this.resource));
            return directChildren;
        }
    }

    static class StructuralChildMapOfResourceT
    extends ResourceRead<Map<String, Resource>> {
        public StructuralChildMapOfResourceT(Resource resource) {
            super(resource);
        }

        public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {
            Map map;
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            Resource definition = graph.getPossibleObject(this.resource, STR.IsDefinedBy);
            if (definition != null && !(map = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(definition))).isEmpty()) {
                return map;
            }
            return Collections.emptyMap();
        }
    }

    static class StructuralRunChildMapOfResource
    extends ResourceRead<Map<String, Resource>> {
        public StructuralRunChildMapOfResource(Resource resource) {
            super(resource);
        }

        public Map<String, Resource> fromContext(ReadGraph graph, Resource context) throws DatabaseException {
            return (Map)graph.sync((ReadInterface)new StructuralChildMapOfResource(context));
        }

        public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
            Resource model = (Resource)graph.sync((ReadInterface)new PossibleIndexRoot(this.resource));
            if (graph.isInstanceOf(model, L0.RVIContext)) {
                return this.fromContext(graph, model);
            }
            Resource configuration = graph.getPossibleObject(model, SIMU.HasConfiguration);
            if (configuration != null && graph.isInstanceOf(configuration, L0.RVIContext)) {
                return this.fromContext(graph, configuration);
            }
            return Collections.emptyMap();
        }
    }

    private static class SubstructureRequest
    extends VariableRead<List<SubstructureElement>> {
        public SubstructureRequest(Variable context) {
            super(context);
        }

        public List<SubstructureElement> perform(ReadGraph graph) {
            Resource type;
            block3: {
                try {
                    type = this.variable.getPossibleType(graph);
                    if (type != null) break block3;
                    return null;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    return null;
                }
            }
            return CompileProceduralComponentTypeRequest.compileAndEvaluate(graph, type, this.variable);
        }
    }
}

