/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.element;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.simantics.jfreechart.chart.element.ResizeListener;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ISelectionPainterNode;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.swing.ComponentNode;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;

public class ChartNode
extends ComponentNode<JPanel>
implements ISelectionPainterNode {
    private static final long serialVersionUID = 5013911689968911010L;
    private boolean hover = false;
    private boolean dragging = false;
    private ResizeListener resizeListener;
    protected transient JFreeChart chart = null;

    public boolean dragging() {
        return this.dragging;
    }

    public void setChart(JFreeChart chart) {
        this.chart = chart;
    }

    public void setResizeListener(ResizeListener listener) {
        this.resizeListener = listener;
    }

    @INode.SyncField(value={"hover"})
    public void setHover(boolean hover) {
        this.hover = hover;
        this.repaint();
    }

    public void cleanup() {
        this.removeEventHandler((IEventHandler)this);
        super.cleanup();
    }

    public void init() {
        super.init();
    }

    public static void expand(Rectangle2D rectangle, double scaleX, double scaleY) {
        GeometryUtils.expandRectangle((Rectangle2D)rectangle, (double)(5.0 * scaleY > 5.0 ? 5.0 * scaleY : 5.0), (double)(3.0 * scaleY > 3.0 ? 3.0 * scaleY : 3.0), (double)(3.0 * scaleX > 3.0 ? 3.0 * scaleX : 3.0), (double)(3.0 * scaleX > 3.0 ? 3.0 * scaleX : 3.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Graphics2D g2d) {
        if (this.component == null && this.chart != null) {
            this.component = new ChartPanel(this.chart, false);
            ((ChartPanel)this.component).setRefreshBuffer(false);
            ((JPanel)this.component).setIgnoreRepaint(true);
            ((JPanel)this.component).setDoubleBuffered(false);
            if (this.bounds != null) {
                ((JPanel)this.component).setBounds(0, 0, 0, 0);
            }
            super.init();
            this.addEventHandler((IEventHandler)this);
        }
        if (this.component != null) {
            boolean selected;
            AffineTransform ot = g2d.getTransform();
            g2d.transform(this.transform);
            double scaleX = g2d.getTransform().getScaleX();
            double scaleY = g2d.getTransform().getScaleY();
            AffineTransform at = new AffineTransform(this.transform);
            AffineTransform affineTransform = this.transform;
            synchronized (affineTransform) {
                at.setToTranslation(this.bounds.getMinX(), this.bounds.getMinY());
                at.scale(1.0 / scaleX, 1.0 / scaleY);
            }
            g2d.transform(at);
            int width = (int)(this.bounds.getWidth() * scaleX);
            int height = (int)(this.bounds.getHeight() * scaleY);
            if (this.hover || this.dragging) {
                Color orig = g2d.getColor();
                BasicStroke oldStroke = (BasicStroke)g2d.getStroke();
                g2d.setColor(Color.LIGHT_GRAY);
                Rectangle2D.Double b = new Rectangle2D.Double(0.0, 0.0, width, height);
                Rectangle2D r = ((Rectangle2D)b).getBounds2D();
                ChartNode.expand(r, 1.0 * scaleX, 1.0 * scaleY);
                g2d.fill(r);
                double x = r.getMaxX() - 0.33 * scaleX;
                double y = r.getMaxY() - 0.33 * scaleY;
                if (r.getMaxX() - x > 0.4) {
                    BasicStroke hilightStroke = new BasicStroke(oldStroke.getLineWidth() * 3.0f);
                    int i = 1;
                    while (i < 4) {
                        Line2D.Double line = new Line2D.Double(x - (double)i * scaleX, y, x, y - (double)i * scaleY);
                        g2d.setStroke(hilightStroke);
                        g2d.setColor(Color.GRAY);
                        g2d.draw(line);
                        g2d.setStroke(oldStroke);
                        g2d.setColor(Color.BLACK);
                        g2d.draw(line);
                        ++i;
                    }
                } else {
                    float f = 3.0f;
                    Rectangle2D.Double corner = new Rectangle2D.Double(r.getMaxX() - (double)f, r.getMaxY() - (double)f, f, f);
                    g2d.setColor(Color.DARK_GRAY);
                    g2d.fill(corner);
                }
                g2d.setStroke(oldStroke);
                g2d.setColor(orig);
            }
            if (selected = NodeUtil.isSelected((INode)this, (int)1)) {
                Color orig = g2d.getColor();
                Stroke origStroke = g2d.getStroke();
                g2d.setColor(Color.RED);
                double s = GeometryUtils.getScale((AffineTransform)g2d.getTransform());
                g2d.setStroke(new BasicStroke(1.0 * s < 1.0 ? 1.0f : 1.0f * (float)s));
                Rectangle2D.Double b = new Rectangle2D.Double(0.0, 0.0, width, height);
                Rectangle2D r = ((Rectangle2D)b).getBounds2D();
                ChartNode.expand(r, scaleX, scaleY);
                g2d.draw(r);
                g2d.setColor(orig);
                g2d.setStroke(origStroke);
            }
            JPanel jPanel = (JPanel)this.component;
            synchronized (jPanel) {
                ((JPanel)this.component).setLocation((int)g2d.getTransform().getTranslateX(), (int)g2d.getTransform().getTranslateY());
                if (((JPanel)this.component).getSize().getWidth() != (double)width || ((JPanel)this.component).getSize().getHeight() != (double)height) {
                    ((JPanel)this.component).setSize(width, height);
                }
                ((JPanel)this.component).paint(g2d);
            }
            g2d.setTransform(ot);
        } else {
            System.out.println("T\ufffd\ufffdLL\ufffd, T\ufffd\ufffdLL\ufffd");
        }
    }

    protected boolean mouseButtonPressed(MouseEvent.MouseButtonPressedEvent event) {
        Point2D local = this.controlToLocal(event.controlPosition);
        local = this.parentToLocal(local);
        Rectangle2D bounds = this.getBoundsInLocal().getBounds2D();
        ChartNode.expand(bounds, 1.0, 1.0);
        double control = 3.0;
        Rectangle2D.Double corner = new Rectangle2D.Double(bounds.getMaxX() - control, bounds.getMaxY() - control, control, control);
        if (this.hover && corner.contains(local)) {
            this.dragging = true;
            return true;
        }
        return super.mouseButtonPressed(event);
    }

    protected boolean mouseMoved(MouseEvent.MouseMovedEvent e) {
        if (this.dragging) {
            Point2D local = this.controlToLocal(e.controlPosition);
            local = this.parentToLocal(local);
            Rectangle2D bounds = this.getBoundsInLocal().getBounds2D();
            if (Math.abs(bounds.getMaxX() - local.getX()) > 3.0 || Math.abs(bounds.getMaxY() - local.getY()) > 3.0) {
                this.resize(local);
            }
            return true;
        }
        return false;
    }

    public boolean hitCorner(Point2D point) {
        Rectangle2D bounds = this.getBoundsInLocal().getBounds2D();
        ChartNode.expand(bounds, 1.0, 1.0);
        double control = 3.0;
        Rectangle2D.Double corner = new Rectangle2D.Double(bounds.getMaxX() - control, bounds.getMaxY() - control, control, control);
        return corner.contains(point);
    }

    private void resize(Point2D local) {
        Rectangle2D bounds = this.getBoundsInLocal().getBounds2D();
        double x = bounds.getX();
        double y = bounds.getY();
        double dx = local.getX() - bounds.getMaxX();
        double dy = local.getY() - bounds.getMaxY();
        double w = bounds.getWidth() + dx;
        double h = bounds.getHeight() + dy;
        bounds.setRect(x, y, w > 20.0 ? w : 20.0, h > 20.0 ? h : 20.0);
        this.setBounds(bounds);
    }

    protected boolean mouseDragged(MouseEvent.MouseDragBegin e) {
        return this.dragging;
    }

    protected boolean mouseButtonReleased(MouseEvent.MouseButtonReleasedEvent e) {
        if (this.dragging) {
            Point2D local = this.controlToLocal(e.controlPosition);
            local = this.parentToLocal(local);
            if (Math.abs(this.bounds.getMaxX() - local.getX()) > 3.0 || Math.abs(this.bounds.getMaxY() - local.getY()) > 3.0) {
                this.resize(local);
            }
            this.dragging = false;
            if (this.resizeListener != null) {
                this.resizeListener.elementResized(this.bounds);
            }
        }
        return false;
    }

    public int getEventMask() {
        return EventTypes.MouseButtonPressedMask | EventTypes.MouseMovedMask | EventTypes.MouseButtonReleasedMask;
    }
}

