/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart;

import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JPanel;
import org.eclipse.swt.widgets.Composite;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.simantics.Simantics;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.IJFreeChart;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.SWTAWTComponent;

public class ChartComposite2
extends SWTAWTComponent {
    private JPanel jPanel;
    private ChartPanel chartPanel;
    private IJFreeChart chart;

    public ChartComposite2(Composite parent, final String chartResourceURI, int style) {
        super(parent, style);
        try {
            Resource chartResource = (Resource)SimanticsUI.getSession().syncRequest((Read)new Read<Resource>(){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    return graph.getPossibleResource(chartResourceURI);
                }
            });
            if (chartResource != null) {
                this.CreateContent(chartResource);
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        this.syncPopulate();
    }

    public ChartComposite2(Composite parent, Resource chartResource, int style) {
        super(parent, style);
        this.CreateContent(chartResource);
        this.syncPopulate();
    }

    protected Component createSwingComponent() {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(new GridLayout(1, 1));
        if (this.chartPanel != null) {
            this.jPanel.add((Component)this.chartPanel);
        }
        this.jPanel.doLayout();
        return this.jPanel;
    }

    protected void setPanel(final ChartPanel panel) {
        ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (ChartComposite2.this.jPanel == null) {
                    ChartComposite2.this.chartPanel = panel;
                } else {
                    ChartComposite2.this.jPanel.removeAll();
                    ChartComposite2.this.chartPanel = panel;
                    ChartComposite2.this.jPanel.add((Component)ChartComposite2.this.chartPanel, "Center");
                    ChartComposite2.this.jPanel.add((Component)ChartComposite2.this.chartPanel);
                    ChartComposite2.this.jPanel.doLayout();
                }
            }
        });
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public IJFreeChart getChart() {
        return this.chart;
    }

    private void CreateContent(final Resource chartResource) {
        Simantics.getSession().asyncRequest((Read)new Read<IJFreeChart>(){

            public IJFreeChart perform(ReadGraph graph) throws DatabaseException {
                if (graph.isInstanceOf(chartResource, JFreeChartResource.getInstance((ReadGraph)graph).Chart)) {
                    if (ChartComposite2.this.chart != null) {
                        ChartComposite2.this.chart.dispose();
                    }
                    ChartComposite2.this.chart = (IJFreeChart)graph.adapt(chartResource, IJFreeChart.class);
                    return ChartComposite2.this.chart;
                }
                return null;
            }
        }, (AsyncListener)new AsyncListener<IJFreeChart>(){

            public boolean isDisposed() {
                return ChartComposite2.this.isDisposed();
            }

            public void execute(AsyncReadGraph graph, IJFreeChart chart) {
                if (chart == null || ChartComposite2.this.isDisposed()) {
                    return;
                }
                JFreeChart jfreeChart = chart.getChart();
                ChartPanel panel = new ChartPanel(jfreeChart, 680, 420, 300, 200, 1024, 768, false, false, true, true, true, true);
                ChartComposite2.this.setPanel(panel);
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                throwable.printStackTrace();
            }
        });
    }
}

