/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.core.manager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.Simantics;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.util.URIUtil;
import org.simantics.db.exception.DatabaseException;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.ContentType;
import org.simantics.export.core.intf.Exporter;
import org.simantics.export.core.intf.Format;
import org.simantics.export.core.manager.Content;
import org.simantics.export.core.manager.ExportAction;
import org.simantics.export.core.util.ExportQueries;

public class ExportSingleContent
extends ExportAction {
    public String contentUri;
    public String contentTypeId;
    public String formatId;
    public Content content;
    public File outputFile;

    public ExportSingleContent(Content content) throws ExportException {
        if (content.url == null || content.formatId == null || content.label == null || content.contentTypeId == null) {
            throw new ExportException("Invalid input parameters in Content (null)");
        }
        this.content = content;
        this.contentUri = content.url;
        this.formatId = content.formatId;
        this.contentTypeId = content.contentTypeId;
    }

    @Override
    public void execute(ExportContext ctx, IProgressMonitor monitor, Variant options) throws ExportException {
        Format format = ctx.eep.getFormat(this.formatId);
        ContentType contentType = ctx.eep.getContentType(this.contentTypeId);
        Exporter[] exporters = ctx.eep.getExporters(this.formatId, this.contentTypeId);
        if (exporters.length == 0) {
            throw new ExportException("No suitable exporter found for exporting " + contentType.label() + " to a " + format.label());
        }
        try {
            String prefix = "___" + URIUtil.encodeFilename((String)this.content.label);
            this.content.tmpFile = this.outputFile = File.createTempFile(prefix, URIUtil.encodeFilename((String)format.fileext()), Simantics.getTemporaryDirectory((String)"export.core"));
        }
        catch (IOException e) {
            throw new ExportException(e);
        }
        Object writer = format.createFile(ctx, this.outputFile, options);
        try {
            try {
                Exporter[] exporterArray = exporters;
                int n = exporters.length;
                int n2 = 0;
                while (n2 < n) {
                    Exporter exporter = exporterArray[n2];
                    exporter.exportAction().export(Collections.singletonList(this.content), writer, ctx, options, monitor, null);
                    ++n2;
                }
            }
            catch (ExportException ee) {
                format.closeFile(ctx, writer);
                writer = null;
                this.outputFile.delete();
                throw ee;
            }
        }
        finally {
            if (writer != null) {
                format.closeFile(ctx, writer);
            }
        }
        monitor.worked(10);
    }

    @Override
    public String label(ExportContext ctx) {
        String label;
        try {
            label = (String)ctx.session.syncRequest(ExportQueries.label(this.contentUri));
        }
        catch (DatabaseException e) {
            label = "<error: " + e.getMessage() + ">";
        }
        if (this.outputFile == null) {
            return label;
        }
        return String.valueOf(label) + " export to " + this.outputFile.getName();
    }

    @Override
    public int work(ExportContext ctx) {
        return 10;
    }

    @Override
    public List<String> validate(ExportContext context, Variant options) {
        Format format = context.eep.getFormat(this.formatId);
        ContentType contentType = context.eep.getContentType(this.contentTypeId);
        Exporter[] exporters = context.eep.getExporters(this.formatId, this.contentTypeId);
        if (exporters.length == 0) {
            return Collections.singletonList("No suitable exporter found for exporting " + contentType.label() + " to a " + format.label());
        }
        ArrayList<String> result = new ArrayList<String>(1);
        Exporter[] exporterArray = exporters;
        int n = exporters.length;
        int n2 = 0;
        while (n2 < n) {
            Exporter exporter = exporterArray[n2];
            try {
                result.addAll(exporter.exportAction().validate(this.contentUri, context, options));
            }
            catch (ExportException e) {
                result.add("Could not create export action for the " + exporter.formatId() + " exporter. " + e.getMessage());
            }
            ++n2;
        }
        return result;
    }

    @Override
    public void cleanup(ExportContext ctx, IProgressMonitor progress, Variant options) throws ExportException {
        if (this.outputFile != null) {
            this.outputFile.delete();
            this.content.tmpFile = null;
        }
    }
}

