/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.runtime;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleActiveRun;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.diagram.runtime.RuntimeDiagramDesc;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;

class RuntimeVariable
extends TernaryRead<Resource, RVI, Resource, RuntimeDiagramDesc> {
    public RuntimeVariable(Resource model, RVI rvi, Resource diagramResource) {
        super((Object)model, (Object)rvi, (Object)diagramResource);
    }

    public RuntimeDiagramDesc perform(ReadGraph graph) throws DatabaseException {
        Resource runtimeProfile;
        Resource model = (Resource)this.parameter;
        RVI rvi = (RVI)this.parameter2;
        Resource diagram = (Resource)this.parameter3;
        Variable variable = null;
        String runtimeProfileURI = null;
        if (model != null && rvi != null) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            if (graph.isInstanceOf(model, L0.IndexRoot)) {
                Variable context;
                Variable activeRun = (Variable)graph.syncRequest((Read)new PossibleActiveRun(model));
                Variable variable2 = context = activeRun != null ? activeRun : Variables.getPossibleConfigurationContext((ReadGraph)graph, (Resource)model);
                if (context != null) {
                    variable = rvi.resolvePossible(graph, context);
                }
            }
        } else {
            Resource composite = graph.getPossibleObject(diagram, ModelingResources.getInstance((ReadGraph)graph).DiagramToComposite);
            if (composite != null) {
                variable = Variables.getPossibleVariable((ReadGraph)graph, (Resource)composite);
            }
        }
        if (model != null && (runtimeProfile = RuntimeVariable.getActiveProfile(graph, model, diagram)) != null) {
            runtimeProfileURI = graph.getPossibleURI(runtimeProfile);
        }
        return new RuntimeDiagramDesc(this.makeModelURI(graph, variable, model), this.makeVariableURI(graph, variable), this.makeRVIString(graph, variable, rvi), runtimeProfileURI);
    }

    String makeModelURI(ReadGraph graph, Variable variable, Resource model) throws DatabaseException {
        if (variable != null) {
            Resource m = Variables.getPossibleIndexRoot((ReadGraph)graph, (Variable)variable);
            return m != null ? graph.getPossibleURI(m) : null;
        }
        return model != null ? graph.getPossibleURI(model) : null;
    }

    String makeVariableURI(ReadGraph graph, Variable variable) throws DatabaseException {
        return variable != null ? variable.getURI(graph) : null;
    }

    String makeRVIString(ReadGraph graph, Variable variable, RVI rvi) throws DatabaseException {
        RVI r;
        if (variable != null && (r = variable.getPossibleRVI(graph)) != null) {
            return r.toString();
        }
        return rvi != null ? rvi.toString() : null;
    }

    private static Resource getActiveProfile(ReadGraph graph, Resource model, Resource diagram) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        return graph.getPossibleObject(model, DIA.HasActiveProfile);
    }
}

