/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteInterface;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.content.EdgeResource;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.RemoveBranchpoint;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.connection.ConnectionEntity;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.elementclass.BranchPoint;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.ErrorLogger;

public class ConnectionCommandHandler
extends AbstractDiagramParticipant {
    @DependencyReflection.Dependency
    MouseUtil mouseUtil;
    @DependencyReflection.Dependency
    Selection selection;

    @EventHandlerReflection.EventHandler(priority=100)
    public boolean handleCommand(CommandEvent event) {
        if (Commands.DELETE.equals((Object)event.command)) {
            try {
                return this.joinConnection();
            }
            catch (DatabaseException e) {
                ErrorLogger.defaultLogError((Throwable)e);
                return false;
            }
        }
        if (Commands.SPLIT_CONNECTION.equals((Object)event.command) && this.routePointsEnabled()) {
            return this.splitConnection();
        }
        if (Commands.ROTATE_ELEMENT_CW.equals((Object)event.command) || Commands.ROTATE_ELEMENT_CCW.equals((Object)event.command)) {
            boolean clockWise = Commands.ROTATE_ELEMENT_CW.equals((Object)event.command);
            try {
                return this.rotateBranchPoint(clockWise);
            }
            catch (DatabaseException e) {
                ErrorLogger.defaultLogError((Throwable)e);
                return false;
            }
        }
        return false;
    }

    private boolean routePointsEnabled() {
        return Boolean.TRUE.equals(this.diagram.getHint(DiagramHints.KEY_ALLOW_ROUTE_POINTS));
    }

    boolean joinConnection() throws DatabaseException {
        final Set<IElement> routePoints = this.getBranchPoints(2);
        if (routePoints.isEmpty()) {
            return false;
        }
        this.selection.clear(0);
        Simantics.getSession().sync((WriteInterface)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                for (IElement routePoint : routePoints) {
                    Object node = ElementUtils.getObject((IElement)routePoint);
                    if (!(node instanceof Resource)) continue;
                    new RemoveBranchpoint(routePoint).perform(graph);
                }
            }
        });
        this.setDirty();
        return true;
    }

    private boolean rotateBranchPoint(final boolean clockWise) throws DatabaseException {
        final Set<IElement> routePoints = this.getBranchPoints(Integer.MAX_VALUE);
        if (routePoints.isEmpty()) {
            return false;
        }
        try {
            SimanticsUI.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                    for (IElement bp : routePoints) {
                        Resource bpr = (Resource)ElementUtils.getObject((IElement)bp);
                        boolean vertical = graph.hasStatement(bpr, DIA.Vertical, bpr);
                        boolean horizontal = graph.hasStatement(bpr, DIA.Horizontal, bpr);
                        BranchPoint.Direction dir = BranchPoint.Direction.toDirection((boolean)horizontal, (boolean)vertical);
                        BranchPoint.Direction newDir = clockWise ? dir.cycleNext() : dir.cyclePrevious();
                        switch (newDir) {
                            case Any: {
                                graph.deny(bpr, DIA.Vertical);
                                graph.deny(bpr, DIA.Horizontal);
                                break;
                            }
                            case Horizontal: {
                                graph.deny(bpr, DIA.Vertical);
                                graph.claim(bpr, DIA.Horizontal, bpr);
                                break;
                            }
                            case Vertical: {
                                graph.deny(bpr, DIA.Horizontal);
                                graph.claim(bpr, DIA.Vertical, bpr);
                            }
                        }
                    }
                }
            });
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        return true;
    }

    boolean splitConnection() {
        final IElement edge = this.getSingleConnectionSegment();
        if (edge == null) {
            return false;
        }
        IDiagram diagram = ElementUtils.peekDiagram((IElement)edge);
        if (diagram == null) {
            return false;
        }
        MouseUtil.MouseInfo mi = this.mouseUtil.getMouseInfo(0);
        final Point2D mousePos = mi.canvasPosition;
        ISnapAdvisor snap = (ISnapAdvisor)this.getHint(DiagramHints.SNAP_ADVISOR);
        if (snap != null) {
            snap.snap(mousePos);
        }
        final AffineTransform splitPos = AffineTransform.getTranslateInstance(mousePos.getX(), mousePos.getY());
        try {
            SimanticsUI.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                    ConnectionUtil cu = new ConnectionUtil(graph);
                    EdgeResource segment = (EdgeResource)ElementUtils.getObject((IElement)edge);
                    Resource bp = cu.split(segment, splitPos);
                    Line2D nearestLine = ConnectionUtil.resolveNearestEdgeLineSegment(mousePos, edge);
                    if (nearestLine != null) {
                        double angle = Math.atan2(Math.abs(nearestLine.getY2() - nearestLine.getY1()), Math.abs(nearestLine.getX2() - nearestLine.getX1()));
                        if (angle >= 0.0 && angle < 0.7853981633974483) {
                            graph.claim(bp, DIA.Horizontal, bp);
                        } else if (angle > 0.7853981633974483 && angle <= 1.5707963267948966) {
                            graph.claim(bp, DIA.Vertical, bp);
                        }
                    }
                }
            });
            this.selection.clear(0);
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        return false;
    }

    Set<IElement> getBranchPoints(int maxDegree) throws DatabaseException {
        Set ss = this.selection.getSelection(0);
        if (ss.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<IElement> result = new HashSet<IElement>();
        ArrayList connections = new ArrayList();
        for (IElement e : ss) {
            if (!e.getElementClass().containsClass(BranchPoint.class)) {
                return Collections.emptySet();
            }
            ConnectionEntity ce = (ConnectionEntity)e.getHint(ElementHints.KEY_CONNECTION_ENTITY);
            if (ce == null) {
                return Collections.emptySet();
            }
            IDiagram diagram = ElementUtils.peekDiagram((IElement)e);
            if (diagram == null) {
                return Collections.emptySet();
            }
            for (Topology topology : diagram.getDiagramClass().getItemsByClass(Topology.class)) {
                connections.clear();
                topology.getConnections(e, ElementUtils.getSingleTerminal((IElement)e), connections);
                int degree = connections.size();
                if (degree < 2 || degree > maxDegree) {
                    return Collections.emptySet();
                }
                result.add(e);
            }
        }
        return result;
    }

    IElement getSingleConnectionSegment() {
        Set s = this.selection.getSelection(0);
        if (s.size() != 1) {
            return null;
        }
        IElement e = (IElement)s.iterator().next();
        if (PickRequest.PickFilter.FILTER_CONNECTIONS.accept(e)) {
            ConnectionEntity ce = (ConnectionEntity)e.getHint(ElementHints.KEY_CONNECTION_ENTITY);
            Collection coll = ce.getBranchPoints(null);
            if (!coll.isEmpty()) {
                return null;
            }
            ce.getSegments(coll);
            if (coll.size() != 1) {
                return null;
            }
            return (IElement)coll.iterator().next();
        }
        if (PickRequest.PickFilter.FILTER_CONNECTION_EDGES.accept(e)) {
            return e;
        }
        return null;
    }

    IElement getSingleConnection() {
        Set ss = this.selection.getSelection(0);
        if (ss.isEmpty()) {
            return null;
        }
        IElement result = null;
        for (IElement e : ss) {
            ConnectionEntity ce = (ConnectionEntity)e.getHint(ElementHints.KEY_CONNECTION_ENTITY);
            if (ce == null) continue;
            if (result != null && !ce.getConnection().equals(result)) {
                return null;
            }
            result = ce.getConnection();
        }
        return result;
    }
}

