/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.content;

import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceAsyncRead;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.diagram.content.ConnectionPartData;
import org.simantics.diagram.content.EdgeResource;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.ErrorHandler;

public class ConnectionPartRequest
extends ResourceAsyncRead<ConnectionPartData> {
    final ErrorHandler errorHandler;
    final DiagramResource dr;

    public ConnectionPartRequest(ErrorHandler errorHandler, DiagramResource dr, Resource resource) {
        super(resource);
        this.errorHandler = errorHandler;
        this.dr = dr;
    }

    public void perform(AsyncReadGraph graph, final AsyncProcedure<ConnectionPartData> procedure) {
        final AtomicInteger ready = new AtomicInteger(3);
        final ConnectionPartData result = new ConnectionPartData();
        final HashSet<EdgeResource> connectorEdges = new HashSet<EdgeResource>();
        final HashSet branchEdges = new HashSet();
        result.edges = connectorEdges;
        result.branchPoints = new ConcurrentLinkedQueue<Resource>();
        AsyncMultiProcedure<Resource> locationProcedure = new AsyncMultiProcedure<Resource>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                ConnectionPartRequest.this.errorHandler.error("forEachObject(connection, Has I/O) failure", throwable);
            }

            public void execute(AsyncReadGraph graph, final Resource location) {
                ready.incrementAndGet();
                graph.forEachObject(location, ConnectionPartRequest.this.dr.AreConnected, (AsyncMultiProcedure)new AsyncMultiProcedure<Resource>(){

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        (this).ConnectionPartRequest.this.errorHandler.error("forEachObject(:I/O Connector, Are Connected) failure", throwable);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void execute(AsyncReadGraph graph, Resource connectedTo) {
                        HashSet hashSet = connectorEdges;
                        synchronized (hashSet) {
                            connectorEdges.add(new EdgeResource(location, connectedTo));
                        }
                    }

                    public void finished(AsyncReadGraph graph) {
                        if (ready.decrementAndGet() == 0) {
                            connectorEdges.addAll(branchEdges);
                            procedure.execute(graph, (Object)result);
                        }
                    }
                });
            }

            public void finished(AsyncReadGraph graph) {
                if (ready.decrementAndGet() == 0) {
                    connectorEdges.addAll(branchEdges);
                    procedure.execute(graph, (Object)result);
                }
            }
        };
        AsyncMultiProcedure<Resource> locationProcedure2 = new AsyncMultiProcedure<Resource>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                ConnectionPartRequest.this.errorHandler.error("forEachObject(connection, Has Branch Point) failure", throwable);
            }

            public void execute(AsyncReadGraph graph, final Resource location) {
                ready.incrementAndGet();
                result.branchPoints.add(location);
                graph.forEachObject(location, ConnectionPartRequest.this.dr.AreConnected, (AsyncMultiProcedure)new AsyncMultiProcedure<Resource>(){

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        (this).ConnectionPartRequest.this.errorHandler.error("forEachObject(:Branch Point, Are Connected) failure", throwable);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void execute(AsyncReadGraph graph, Resource connectedTo) {
                        HashSet hashSet = branchEdges;
                        synchronized (hashSet) {
                            branchEdges.add(new EdgeResource(location, connectedTo));
                        }
                    }

                    public void finished(AsyncReadGraph graph) {
                        if (ready.decrementAndGet() == 0) {
                            connectorEdges.addAll(branchEdges);
                            procedure.execute(graph, (Object)result);
                        }
                    }
                });
            }

            public void finished(AsyncReadGraph graph) {
                if (ready.decrementAndGet() == 0) {
                    connectorEdges.addAll(branchEdges);
                    procedure.execute(graph, (Object)result);
                }
            }
        };
        AsyncMultiProcedure<Resource> locationProcedure3 = new AsyncMultiProcedure<Resource>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                ConnectionPartRequest.this.errorHandler.error("forEachObject(connection, Has I/O) failure", throwable);
            }

            public void execute(AsyncReadGraph graph, final Resource location) {
                ready.incrementAndGet();
                graph.forEachObject(location, ConnectionPartRequest.this.dr.AreConnected, (AsyncMultiProcedure)new AsyncMultiProcedure<Resource>(){

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        (this).ConnectionPartRequest.this.errorHandler.error("forEachObject(:I/O Connector, Are Connected) failure", throwable);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void execute(AsyncReadGraph graph, Resource connectedTo) {
                        HashSet hashSet = connectorEdges;
                        synchronized (hashSet) {
                            connectorEdges.add(new EdgeResource(connectedTo, location));
                        }
                    }

                    public void finished(AsyncReadGraph graph) {
                        if (ready.decrementAndGet() == 0) {
                            connectorEdges.addAll(branchEdges);
                            procedure.execute(graph, (Object)result);
                        }
                    }
                });
            }

            public void finished(AsyncReadGraph graph) {
                if (ready.decrementAndGet() == 0) {
                    connectorEdges.addAll(branchEdges);
                    procedure.execute(graph, (Object)result);
                }
            }
        };
        graph.forEachObject(this.resource, this.dr.HasPlainConnector, (AsyncMultiProcedure)locationProcedure);
        graph.forEachObject(this.resource, this.dr.HasBranchPoint, (AsyncMultiProcedure)locationProcedure2);
        graph.forEachObject(this.resource, this.dr.HasArrowConnector, (AsyncMultiProcedure)locationProcedure3);
    }
}

