/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.image.Image;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.utils.datastructures.hints.IHintContext;

public class CompositeImage
implements Image {
    Collection<IElement> elements;
    private Shape shape;
    private Rectangle2D bounds;
    static EnumSet<Image.Feature> feats = VOLATILE_VECTOR;
    public static final IHintContext.Key KEY_SG_NODE = new SceneGraphNodeKey(Node.class, "COMPOSITE_IMAGE_SG_NODE");
    Rectangle2D tempBounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);

    public CompositeImage(Collection<IElement> elements) {
        this.elements = elements;
    }

    public Rectangle2D getBounds() {
        if (this.bounds == null) {
            Shape shape = this.getShape();
            if (shape == null) {
                return new Rectangle2D.Double();
            }
            this.bounds = shape.getBounds2D();
        }
        return this.bounds;
    }

    public EnumSet<Image.Feature> getFeatures() {
        return feats;
    }

    private final Shape getShape() {
        if (this.shape == null) {
            this.shape = ElementUtils.getElementBoundsOnDiagram(this.elements);
        }
        return this.shape;
    }

    public Shape getOutline() {
        return this.getShape();
    }

    public Collection<IElement> getElements() {
        return this.elements;
    }

    public void addImageListener(Image.ImageListener listener) {
    }

    public void removeImageListener(Image.ImageListener listener) {
    }

    public Node init(G2DParentNode parent) {
        Iterator<IElement> iterator;
        if (this.elements.size() < 2 && (iterator = this.elements.iterator()).hasNext()) {
            IElement e = iterator.next();
            ElementClass ec = e.getElementClass();
            G2DParentNode node = (G2DParentNode)parent.getOrCreateNode("composite_image_" + this.hashCode(), G2DParentNode.class);
            List nodeHandlers = ec.getItemsByClass(SceneGraph.class);
            for (SceneGraph n : nodeHandlers) {
                n.init(e, node);
            }
            return node;
        }
        G2DParentNode node = (G2DParentNode)parent.getOrCreateNode("composite_image_" + this.hashCode(), G2DParentNode.class);
        int zIndex = 0;
        for (IElement e : this.elements) {
            ElementClass ec = e.getElementClass();
            SingleElementNode holder = (SingleElementNode)node.getOrCreateNode(ElementUtils.generateNodeId((IElement)e), SingleElementNode.class);
            holder.setZIndex(++zIndex);
            holder.setKey(e.getHint(ElementHints.KEY_OBJECT));
            holder.setTypeClass((String)e.getHint(ElementHints.KEY_TYPE_CLASS));
            List nodeHandlers = ec.getItemsByClass(SceneGraph.class);
            for (SceneGraph n : nodeHandlers) {
                n.init(e, (G2DParentNode)holder);
            }
        }
        return node;
    }
}

