/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.cache;

import java.lang.ref.SoftReference;
import org.simantics.utils.datastructures.cache.IProvider;
import org.simantics.utils.datastructures.cache.ProvisionException;

public class SoftCachedProvider<V>
implements IProvider<V> {
    IProvider<V> provider;
    SoftReference<V> ref;

    public static final <V> IProvider<V> cache(IProvider<V> provider) {
        if (provider instanceof SoftCachedProvider) {
            return provider;
        }
        return new SoftCachedProvider<V>(provider);
    }

    SoftCachedProvider(IProvider<V> orig) {
        this.provider = orig;
    }

    @Override
    public synchronized V get() throws ProvisionException {
        V x;
        if (this.ref != null) {
            x = this.ref.get();
            if (x == null) {
                this.ref = null;
            } else {
                return x;
            }
        }
        x = this.provider.get();
        this.ref = new SoftReference<V>(x);
        return x;
    }

    public int hashCode() {
        return this.provider.hashCode();
    }

    public boolean equals(Object obj) {
        return this.provider.equals(obj);
    }
}

