/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.modulebrowser;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.Activator;
import org.simantics.scl.ui.editor2.OpenSCLModule;
import org.simantics.scl.ui.modulebrowser.CreateModuleDialog;
import org.simantics.scl.ui.modulebrowser.ModuleNameTreeEntry;
import org.simantics.scl.ui.modulebrowser.SCLModuleTree;

public class SCLModuleBrowser
extends ViewPart {
    SCLModuleTree content;

    public void createPartControl(Composite parent) {
        this.content = new SCLModuleTree(parent, 0, SCLOsgi.MODULE_REPOSITORY);
        this.setPartName("SCL Modules");
        this.content.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                ModuleNameTreeEntry entry = (ModuleNameTreeEntry)((IStructuredSelection)selection).getFirstElement();
                if (entry.isModule) {
                    OpenSCLModule.openModule(entry.fullName);
                }
            }
        });
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)new Action("Refresh modules", Activator.imageDescriptorFromPlugin((String)"org.simantics.scl.ui", (String)"icons/arrow_refresh.png")){

            public void run() {
                SCLModuleBrowser.this.refresh();
            }
        });
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                final ModuleNameTreeEntry entry = (ModuleNameTreeEntry)SCLModuleBrowser.this.content.getStructuredSelection().getFirstElement();
                manager.add((IAction)new Action("New Module..."){

                    public void run() {
                        CreateModuleDialog dialog = new CreateModuleDialog((this).SCLModuleBrowser.this.content.getControl().getShell(), SCLModuleBrowser.this);
                        dialog.setPackage(entry.fullName);
                        dialog.open();
                    }
                });
            }
        });
        Menu menu = menuMgr.createContextMenu(this.content.getControl());
        this.content.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.content);
    }

    public void refresh() {
        SCLOsgi.MODULE_REPOSITORY.getSourceRepository().checkUpdates();
        this.content.recalculateInput();
    }

    public void setFocus() {
        this.content.getControl().setFocus();
    }
}

