/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.console;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.compiler.commands.SCLConsoleListener;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.reporting.AbstractSCLReportingHandler;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;
import org.simantics.scl.ui.Activator;
import org.simantics.scl.ui.assist.SCLContentProposalProvider;
import org.simantics.scl.ui.assist.StyledTextContentAdapter;
import org.simantics.scl.ui.console.AbstractCommandConsole;
import org.simantics.scl.ui.console.ErrorAnnotation;
import org.simantics.scl.ui.console.IdentitySchedulingRule;

public class SCLConsole
extends AbstractCommandConsole {
    public static final String JOB_NAME = "org.simantics.scl.console.job";
    public static final long TERMINATE_GRACE_PERIOD = 1000L;
    private THashSet<Job> currentJobs = new THashSet();
    private final IdentitySchedulingRule schedulingRule = new IdentitySchedulingRule();
    private ArrayList<SCLConsoleListener> listeners = new ArrayList(2);
    private boolean consoleIsEmpty = true;
    SCLReportingHandler handler = new AbstractSCLReportingHandler(){

        public void print(String text) {
            SCLConsole.this.appendOutput(String.valueOf(text) + "\n", null, null);
        }

        public void printError(String error) {
            SCLConsole.this.appendOutput(String.valueOf(error) + "\n", SCLConsole.this.redColor, null);
        }

        public void printCommand(String command) {
            SCLConsole.this.appendOutput("> " + command.replace("\n", "\n  ") + "\n", SCLConsole.this.greenColor, null);
        }
    };
    CommandSession session = new CommandSession(SCLOsgi.MODULE_REPOSITORY, this.handler);
    ContentProposalAdapter contentProposalAdapter;

    public SCLConsole(Composite parent, int style) {
        super(parent, style);
        StyledTextContentAdapter styledTextContentAdapter = new StyledTextContentAdapter();
        SCLContentProposalProvider contentProvider = new SCLContentProposalProvider(this.session);
        try {
            this.contentProposalAdapter = new ContentProposalAdapter((Control)this.input, (IControlContentAdapter)styledTextContentAdapter, (IContentProposalProvider)contentProvider, KeyStroke.getInstance((String)"Ctrl+Space"), null);
            this.contentProposalAdapter.setAutoActivationDelay(200);
        }
        catch (ParseException parseException) {}
        this.addContributedListeners();
    }

    @Override
    protected boolean canExecuteCommand() {
        return !this.contentProposalAdapter.isProposalPopupOpen();
    }

    @Override
    public ErrorAnnotation[] validate(String command) {
        if (command.isEmpty()) {
            return ErrorAnnotation.EMPTY_ARRAY;
        }
        CompilationError[] errors = this.session.validate(command);
        if (errors.length == 0) {
            return ErrorAnnotation.EMPTY_ARRAY;
        }
        ErrorAnnotation[] annotations = new ErrorAnnotation[errors.length];
        int i = 0;
        while (i < errors.length) {
            int end;
            CompilationError error = errors[i];
            int begin = Locations.beginOf((long)error.location);
            if (begin == Integer.MAX_VALUE) {
                begin = 0;
            }
            if ((end = Locations.endOf((long)error.location)) == Integer.MIN_VALUE) {
                end = command.length();
            }
            if (begin == end) {
                if (begin > 0) {
                    --begin;
                } else {
                    ++end;
                }
            }
            annotations[i] = new ErrorAnnotation(begin, end, error.description);
            ++i;
        }
        return annotations;
    }

    private String jobNameFromCommand(String command) {
        return command.split("\n")[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final String command) {
        Job job = new Job(this.jobNameFromCommand(command)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                block12: {
                    try {
                        SCLConsole.this.session.execute(command, SCLConsole.this.handler);
                        break block12;
                    }
                    catch (Throwable throwable) {
                        THashSet tHashSet = SCLConsole.this.currentJobs;
                        synchronized (tHashSet) {
                            SCLConsole.this.currentJobs.remove((Object)this);
                            if (SCLConsole.this.currentJobs.isEmpty()) {
                                for (SCLConsoleListener listener : SCLConsole.this.listeners) {
                                    listener.finishedExecution();
                                }
                            }
                        }
                    }
                    throw throwable;
                }
                THashSet tHashSet = SCLConsole.this.currentJobs;
                synchronized (tHashSet) {
                    SCLConsole.this.currentJobs.remove((Object)this);
                    if (SCLConsole.this.currentJobs.isEmpty()) {
                        for (SCLConsoleListener listener : SCLConsole.this.listeners) {
                            listener.finishedExecution();
                        }
                    }
                }
                return Status.OK_STATUS;
            }

            protected void canceling() {
                Thread thread = this.getThread();
                if (thread != null) {
                    thread.interrupt();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
                thread = this.getThread();
                if (thread != null) {
                    thread.stop();
                }
            }
        };
        job.setRule((ISchedulingRule)this.schedulingRule);
        THashSet<Job> tHashSet = this.currentJobs;
        synchronized (tHashSet) {
            boolean firstJob = this.currentJobs.isEmpty();
            this.currentJobs.add((Object)job);
            if (firstJob) {
                ArrayList<SCLConsoleListener> arrayList = this.listeners;
                synchronized (arrayList) {
                    for (SCLConsoleListener listener : this.listeners) {
                        listener.startedExecution();
                    }
                }
            }
        }
        job.schedule();
    }

    public CommandSession getSession() {
        return this.session;
    }

    public SCLReportingHandler getHandler() {
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptCurrentCommands() {
        THashSet<Job> tHashSet = this.currentJobs;
        synchronized (tHashSet) {
            for (Job job : this.currentJobs) {
                job.cancel();
            }
            this.currentJobs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SCLConsoleListener listener) {
        ArrayList<SCLConsoleListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SCLConsoleListener listener) {
        ArrayList<SCLConsoleListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendOutput(String text, Color foreground, Color background) {
        super.appendOutput(text, foreground, background);
        if (this.consoleIsEmpty) {
            this.consoleIsEmpty = false;
            ArrayList<SCLConsoleListener> arrayList = this.listeners;
            synchronized (arrayList) {
                for (SCLConsoleListener listener : this.listeners) {
                    listener.consoleIsNotEmptyAnymore();
                }
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.consoleIsEmpty = true;
    }

    private void addContributedListeners() {
        BundleContext context = Activator.getInstance().getBundle().getBundleContext();
        new ServiceTracker<SCLConsoleListener, SCLConsoleListener>(context, SCLConsoleListener.class, null){

            public SCLConsoleListener addingService(ServiceReference<SCLConsoleListener> reference) {
                SCLConsoleListener listener = (SCLConsoleListener)this.context.getService(reference);
                SCLConsole.this.addListener(listener);
                return listener;
            }

            public void modifiedService(ServiceReference<SCLConsoleListener> reference, SCLConsoleListener service) {
            }

            public void removedService(ServiceReference<SCLConsoleListener> reference, SCLConsoleListener service) {
                SCLConsole.this.removeListener(service);
            }
        }.open();
    }
}

