/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.osgi.internal;

import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.simantics.scl.compiler.internal.codegen.types.JavaReferenceValidatorFactory;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.EncodedTextualModuleSource;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.osgi.internal.OsgiJavaReferenceValidatorFactory;

public class BundleModuleSource
extends EncodedTextualModuleSource
implements UpdateListener.Observable {
    public static final ImportDeclaration[] DEFAULT_IMPORTS = new ImportDeclaration[]{new ImportDeclaration("Builtin", ""), new ImportDeclaration("StandardLibrary", "")};
    public static final ImportDeclaration[] DEFAULT_IMPORTS_FOR_STANDARD_LIBRARY = new ImportDeclaration[]{new ImportDeclaration("Builtin", "")};
    public final Bundle bundle;
    public final URL url;
    private byte[] digest;
    private THashSet<UpdateListener> listeners;

    public BundleModuleSource(String moduleName, Bundle bundle, URL url) {
        super(moduleName);
        this.bundle = bundle;
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(UpdateListener listener) {
        if (this.listeners != null) {
            THashSet<UpdateListener> tHashSet = this.listeners;
            synchronized (tHashSet) {
                this.listeners.remove((Object)listener);
            }
        }
    }

    public ImportDeclaration[] getBuiltinImports(UpdateListener listener) {
        if (this.bundle.getSymbolicName().equals("org.simantics.scl.runtime")) {
            return DEFAULT_IMPORTS_FOR_STANDARD_LIBRARY;
        }
        return DEFAULT_IMPORTS;
    }

    private byte[] computeDigest() {
        byte[] byArray;
        InputStream stream = this.url.openStream();
        try {
            int count;
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            byte[] buffer = new byte[1024];
            while ((count = stream.read(buffer)) > 0) {
                digest.update(buffer, 0, count);
            }
            byArray = digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            byte[] byArray2;
            try {
                e.printStackTrace();
                byArray2 = new byte[]{};
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    return new byte[0];
                }
            }
            stream.close();
            return byArray2;
        }
        stream.close();
        return byArray;
    }

    protected InputStream getSourceStream(UpdateListener listener) throws IOException {
        if (this.digest == null) {
            this.digest = this.computeDigest();
        }
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new THashSet(4);
            }
            this.listeners.add((Object)listener);
            listener.addObservable((UpdateListener.Observable)this);
        }
        return this.url.openStream();
    }

    public ClassLoader getClassLoader() {
        if (this.bundle.getSymbolicName().equals("org.simantics.scl.runtime")) {
            return Type.class.getClassLoader();
        }
        BundleWiring wiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
        if (wiring != null) {
            return wiring.getClassLoader();
        }
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    public void checkUpdates() {
        byte[] newDigest;
        if (this.digest != null && this.listeners != null && !Arrays.equals(this.digest, newDigest = this.computeDigest())) {
            this.digest = newDigest;
            THashSet<UpdateListener> oldListeners = this.listeners;
            this.listeners = null;
            for (UpdateListener listener : oldListeners) {
                listener.notifyAboutUpdate();
            }
        }
    }

    public static File resolveWritableBundleFile(URL url) throws IOException {
        URL resolved = FileLocator.resolve((URL)url);
        if (resolved.getProtocol().equals("file")) {
            return new File(resolved.getPath());
        }
        return null;
    }

    private Path getPath() throws IOException {
        File file = BundleModuleSource.resolveWritableBundleFile(this.url);
        return file != null ? file.toPath() : null;
    }

    public boolean isUpdateable() {
        try {
            return Files.exists(this.getPath(), new LinkOption[0]);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void update(String newSourceText) {
        try {
            Path path = this.getPath();
            Files.write(path, newSourceText.getBytes(Charset.forName("UTF-8")), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.checkUpdates();
    }

    public void clear() {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
    }

    public JavaReferenceValidatorFactory getJavaReferenceValidatorFactory() {
        return new OsgiJavaReferenceValidatorFactory(this.bundle);
    }
}

