/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.formula;

import java.util.HashMap;
import java.util.Map;
import org.simantics.spreadsheet.graph.CellFormulaFunction;
import org.simantics.spreadsheet.graph.SpreadsheetBook;
import org.simantics.spreadsheet.graph.formula.AndFormulaFunction;
import org.simantics.spreadsheet.graph.formula.AverageFormulaFunction;
import org.simantics.spreadsheet.graph.formula.CountifFormulaFunction;
import org.simantics.spreadsheet.graph.formula.GeomeanFormulaFunction;
import org.simantics.spreadsheet.graph.formula.HlookupFormulaFunction;
import org.simantics.spreadsheet.graph.formula.IfErrorFormulaFunction;
import org.simantics.spreadsheet.graph.formula.IfFormulaFunction;
import org.simantics.spreadsheet.graph.formula.IsErrorFormulaFunction;
import org.simantics.spreadsheet.graph.formula.LinestFormulaFunction;
import org.simantics.spreadsheet.graph.formula.MatchFormulaFunction;
import org.simantics.spreadsheet.graph.formula.OrFormulaFunction;
import org.simantics.spreadsheet.graph.formula.PiFormulaFunction;
import org.simantics.spreadsheet.graph.formula.RoundFormulaFunction;
import org.simantics.spreadsheet.graph.formula.RoundupFormulaFunction;
import org.simantics.spreadsheet.graph.formula.SqrtFormulaFunction;
import org.simantics.spreadsheet.graph.formula.SumFormulaFunction;
import org.simantics.spreadsheet.graph.formula.SumifFormulaFunction;
import org.simantics.spreadsheet.graph.formula.TodayFormulaFunction;
import org.simantics.spreadsheet.graph.formula.VlookupFormulaFunction;

public class SpreadsheetEvaluationEnvironment {
    private final SpreadsheetBook book;
    private Map<String, CellFormulaFunction<?>> functions = new HashMap();
    public int iterationLimit = 100;
    private static Map<SpreadsheetBook, SpreadsheetEvaluationEnvironment> INSTANCES = new HashMap<SpreadsheetBook, SpreadsheetEvaluationEnvironment>();

    public SpreadsheetEvaluationEnvironment(SpreadsheetBook book) {
        this.book = book;
        this.functions.put("MATCH", new MatchFormulaFunction());
        this.functions.put("ISERROR", new IsErrorFormulaFunction());
        this.functions.put("IFERROR", new IfErrorFormulaFunction());
        this.functions.put("IF", new IfFormulaFunction());
        this.functions.put("OR", new OrFormulaFunction());
        this.functions.put("AND", new AndFormulaFunction());
        this.functions.put("ROUND", new RoundFormulaFunction());
        this.functions.put("ROUNDUP", new RoundupFormulaFunction());
        this.functions.put("SQRT", new SqrtFormulaFunction());
        this.functions.put("PI", new PiFormulaFunction());
        this.functions.put("COUNTIF", new CountifFormulaFunction());
        this.functions.put("SUM", new SumFormulaFunction());
        this.functions.put("AVERAGE", new AverageFormulaFunction());
        this.functions.put("SUMIF", new SumifFormulaFunction());
        this.functions.put("VLOOKUP", new VlookupFormulaFunction());
        this.functions.put("HLOOKUP", new HlookupFormulaFunction());
        this.functions.put("TODAY", new TodayFormulaFunction());
        this.functions.put("LINEST", new LinestFormulaFunction());
        this.functions.put("GEOMEAN", new GeomeanFormulaFunction());
    }

    public CellFormulaFunction<?> getFunction(String name) {
        return this.functions.get(name);
    }

    public SpreadsheetBook getBook() {
        return this.book;
    }

    public static SpreadsheetEvaluationEnvironment getInstance(SpreadsheetBook book) {
        SpreadsheetEvaluationEnvironment env = INSTANCES.get(book);
        if (env == null) {
            env = new SpreadsheetEvaluationEnvironment(book);
            INSTANCES.put(book, env);
        }
        return env;
    }

    public static boolean removeInstance(SpreadsheetBook book) {
        return INSTANCES.remove(book) != null;
    }
}

