/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.graph.SheetNode;
import org.simantics.spreadsheet.graph.SpreadsheetCell;
import org.simantics.spreadsheet.graph.SpreadsheetElement;
import org.simantics.spreadsheet.graph.SpreadsheetEngine;
import org.simantics.spreadsheet.graph.SpreadsheetLines;
import org.simantics.spreadsheet.graph.SpreadsheetTypeNode;
import org.simantics.spreadsheet.graph.SpreadsheetVisitor;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

public class SpreadsheetLine
implements SpreadsheetElement<SpreadsheetCell, SpreadsheetLines>,
SheetNode {
    private static final long serialVersionUID = -304574098117404663L;
    private final SpreadsheetLines parent;
    public final int row;
    int id;
    public ObjectArrayList<SpreadsheetCell> cells = new ObjectArrayList();

    public SpreadsheetLine(SpreadsheetLines parent, int row) {
        this.parent = parent;
        this.row = row;
        this.id = this.getEngine().getBook().getNewId(this);
    }

    public int getId() {
        return this.id;
    }

    public SpreadsheetEngine getEngine() {
        return this.parent.getEngine();
    }

    @Override
    public String getName() {
        return "Row" + this.row;
    }

    public Map getChildren() {
        String rowName = "" + this.row;
        HashMap<String, SpreadsheetCell> result = new HashMap<String, SpreadsheetCell>();
        int i = 0;
        while (i < this.cells.size()) {
            SpreadsheetCell cell = (SpreadsheetCell)this.cells.get(i);
            if (SpreadsheetCell.EMPTY != cell) {
                String name = "Row" + SpreadsheetUtils.columnName((int)i) + rowName;
                result.put(name, cell);
            }
            ++i;
        }
        return result;
    }

    public Map getProperties() {
        return Collections.singletonMap("typeURI", new SpreadsheetTypeNode("http://www.simantics.org/Spreadsheet-1.2/Line"));
    }

    Object resolve(String[] parts, int index) {
        if (index == parts.length) {
            return this;
        }
        Range r = SpreadsheetUtils.decodeCellAbsolute((String)parts[index]);
        return this.cells.get(r.startColumn);
    }

    @Override
    public void accept(SpreadsheetVisitor v) {
        v.visit(this);
    }

    public String getPath() {
        return String.valueOf(this.parent.getPath()) + "/" + this.getName();
    }

    @Override
    public Optional<SpreadsheetLines> getParent() {
        return Optional.of(this.parent);
    }

    @Override
    public List<SpreadsheetCell> getSpreadsheetChildren() {
        return this.cells;
    }

    @Override
    public void remove(SpreadsheetCell child) {
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + this.row;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpreadsheetLine other = (SpreadsheetLine)obj;
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return this.row == other.row;
    }
}

