/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Array;
import fi.semantum.sysdyn.solver.ArraySliceExpression;
import fi.semantum.sysdyn.solver.Constant;
import fi.semantum.sysdyn.solver.IEnvironment;
import fi.semantum.sysdyn.solver.IExpression;
import fi.semantum.sysdyn.solver.VariableBase;

public class SolverUtils {
    public static boolean isFullSubscript(IExpression[] subscripts) {
        if (subscripts == null) {
            return true;
        }
        int i = 0;
        while (i < subscripts.length) {
            block6: {
                block5: {
                    Double d;
                    if (!(subscripts[i] instanceof Constant)) break block5;
                    Constant c = (Constant)subscripts[i];
                    if (c.value instanceof Double && (d = (Double)c.value) == -1.0) break block6;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isArray(int[] dimensions) {
        return dimensions != null && dimensions != VariableBase.UNINIT;
    }

    public static Array[] parseSubscripts(IEnvironment env, IExpression[] subscripts) {
        Array[] result = new Array[subscripts.length];
        int i = 0;
        while (i < subscripts.length) {
            IExpression e = subscripts[i];
            if (e instanceof ArraySliceExpression) {
                ArraySliceExpression ase = (ArraySliceExpression)e;
                Double start = (Double)ase.start.evaluate(env);
                Double end = (Double)ase.end.evaluate(env);
                result[i] = Array.slice(start.intValue() - 1, end.intValue() - 1);
            } else if (e instanceof Array) {
                Array array = (Array)e;
                Array r = new Array();
                for (Object o : array.elements()) {
                    Double d = (Double)o;
                    r.addElement(d - 1.0);
                }
                result[i] = r;
            } else {
                Double v = (Double)e.evaluate(env);
                int index = v.intValue() - 1;
                result[i] = index == -2 ? Array.FULL : Array.singleton(index);
            }
            ++i;
        }
        return result;
    }

    public static boolean isSlice(Array[] subs) {
        Array[] arrayArray = subs;
        int n = subs.length;
        int n2 = 0;
        while (n2 < n) {
            Array s = arrayArray[n2];
            if (s.dimension() != 1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static class Slice {
        public static final Slice FULL = new Slice(-2, -1);
        public int start;
        public int end;

        public Slice(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

