/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.ArgumentList;
import fi.semantum.sysdyn.solver.Array;
import fi.semantum.sysdyn.solver.Fn1;
import fi.semantum.sysdyn.solver.FnRandom;
import fi.semantum.sysdyn.solver.IEnvironment;
import fi.semantum.sysdyn.solver.ISystem;
import fi.semantum.sysdyn.solver.Model;
import fi.semantum.sysdyn.solver.NormalDistribution;
import fi.semantum.sysdyn.solver.Variable;
import fi.semantum.sysdyn.solver.VariableBase;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;

public final class Environment
implements IEnvironment,
ISystem {
    final Map<String, Object> named = new HashMap<String, Object>();
    public Model model;
    public double step;
    public double time;
    public boolean initial = true;
    public int size;
    public Object[] valueTable;
    public TObjectIntHashMap<String> keyIndexMap = new TObjectIntHashMap();
    HashMap<String, TreeMap<Double, Double>> history = new HashMap();
    double[] valueArray;
    int[] valueIndices;
    private Set<Object> assigned = new HashSet<Object>();

    public Environment(Model model, double step, double start) {
        this.model = model;
        this.step = step;
        this.time = start;
        model.functions.put("sin", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.sin(x);
            }
        });
        model.functions.put("cos", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.cos(x);
            }
        });
        model.functions.put("tan", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.tan(x);
            }
        });
        model.functions.put("asin", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.asin(x);
            }
        });
        model.functions.put("acos", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.acos(x);
            }
        });
        model.functions.put("atan", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.atan(x);
            }
        });
        model.functions.put("toRadians", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.toRadians(x);
            }
        });
        model.functions.put("toDegrees", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.toDegrees(x);
            }
        });
        model.functions.put("exp", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.exp(x);
            }
        });
        model.functions.put("log", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.log(x);
            }
        });
        model.functions.put("log10", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.log10(x);
            }
        });
        model.functions.put("sqrt", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.sqrt(x);
            }
        });
        model.functions.put("cbrt", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.cbrt(x);
            }
        });
        model.functions.put("mod", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                Double y = (Double)environment.getValue(1);
                return this.mod(x, y);
            }

            double mod(double x, double y) {
                return x - Math.floor(x / y) * y;
            }
        });
        model.functions.put("rem", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                Double y = (Double)environment.getValue(1);
                return Math.IEEEremainder(x, y);
            }
        });
        model.functions.put("ceil", new Fn1(1){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Object value = environment.getValue(0);
                if (value instanceof Double) {
                    return Math.ceil((Double)value);
                }
                if (value instanceof Array) {
                    return ((Array)value).copy(new Array.Modifier(){

                        @Override
                        public Object modify(Object o) {
                            if (o instanceof Double) {
                                return Math.ceil((Double)o);
                            }
                            throw new IllegalStateException();
                        }
                    });
                }
                throw new IllegalStateException();
            }
        });
        model.functions.put("floor", new Fn1(1){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Object value = environment.getValue(0);
                if (value instanceof Double) {
                    return Math.floor((Double)value);
                }
                if (value instanceof Array) {
                    return ((Array)value).copy(new Array.Modifier(){

                        @Override
                        public Object modify(Object o) {
                            if (o instanceof Double) {
                                return Math.floor((Double)o);
                            }
                            throw new IllegalStateException();
                        }
                    });
                }
                throw new IllegalStateException();
            }
        });
        model.functions.put("rint", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.rint(x);
            }
        });
        model.functions.put("atan2", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                Double y = (Double)environment.getValue(1);
                return Math.atan2(x, y);
            }
        });
        model.functions.put("pow", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                Double y = (Double)environment.getValue(1);
                return Math.pow(x, y);
            }
        });
        model.functions.put("round", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                long result = Math.round(x);
                return (int)result;
            }
        });
        model.functions.put("abs", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Object o = environment.getValue(0);
                if (o instanceof Double) {
                    return Math.abs((Double)o);
                }
                if (o instanceof Integer) {
                    return Math.abs((Integer)o);
                }
                throw new IllegalStateException("Unsupported argument to abs: " + o);
            }
        });
        model.functions.put("min", new Fn1(5){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Object first = environment.getValue(0);
                if (first instanceof Double) {
                    Double result = (Double)first;
                    int i = 1;
                    while (i < argc) {
                        Double d = (Double)environment.getValue(i);
                        if (d < result) {
                            result = d;
                        }
                        ++i;
                    }
                    return result;
                }
                if (first instanceof Integer) {
                    Integer result = (Integer)first;
                    int i = 1;
                    while (i < argc) {
                        Integer d = (Integer)environment.getValue(i);
                        if (d < result) {
                            result = d;
                        }
                        ++i;
                    }
                    return result;
                }
                throw new IllegalStateException("Unsupported argument to min: " + first);
            }
        });
        model.functions.put("max", new Fn1(5){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Object first = environment.getValue(0);
                if (first instanceof Double) {
                    Double result = (Double)first;
                    int i = 1;
                    while (i < argc) {
                        Double d = (Double)environment.getValue(i);
                        if (d > result) {
                            result = d;
                        }
                        ++i;
                    }
                    return result;
                }
                if (first instanceof Integer) {
                    Integer result = (Integer)first;
                    int i = 1;
                    while (i < argc) {
                        Integer d = (Integer)environment.getValue(i);
                        if (d > result) {
                            result = d;
                        }
                        ++i;
                    }
                    return result;
                }
                throw new IllegalStateException("Unsupported argument to max: " + first);
            }
        });
        model.functions.put("ulp", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.ulp(x);
            }
        });
        model.functions.put("signum", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.signum(x);
            }
        });
        model.functions.put("sinh", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.sinh(x);
            }
        });
        model.functions.put("cosh", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.cosh(x);
            }
        });
        model.functions.put("tanh", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.tanh(x);
            }
        });
        model.functions.put("hypot", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                Double y = (Double)environment.getValue(1);
                return Math.hypot(x, y);
            }
        });
        model.functions.put("expm1", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.expm1(x);
            }
        });
        model.functions.put("log1p", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.log1p(x);
            }
        });
        model.functions.put("copySign", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                Double y = (Double)environment.getValue(1);
                return Math.copySign(x, y);
            }
        });
        model.functions.put("getExponent", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.getExponent(x);
            }
        });
        model.functions.put("nextAfter", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                Double y = (Double)environment.getValue(1);
                return Math.nextAfter(x, (double)y);
            }
        });
        model.functions.put("nextUp", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                return Math.nextUp(x);
            }
        });
        model.functions.put("scalb", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double x = (Double)environment.getValue(0);
                Integer y = (Integer)environment.getValue(1);
                return Math.scalb(x, (int)y);
            }
        });
        model.functions.put("size", new Fn1(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Array array = (Array)environment.getValue(0);
                Double col = (Double)environment.getValue(1);
                return (double)array.size(col.intValue());
            }
        });
        model.functions.put("zidz", new Fn1(2){

            private Object evaluate(Double p1, Double p2) {
                if (Math.abs(p2) < 1.0E-12) {
                    return 0.0;
                }
                return p1 / p2;
            }

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Object o1 = environment.getValue(0);
                Object o2 = environment.getValue(1);
                if (o1 instanceof Double && o2 instanceof Double) {
                    return this.evaluate((Double)o1, (Double)o2);
                }
                if (o1 instanceof Array && o2 instanceof Array) {
                    Array la = (Array)o1;
                    Array ra = (Array)o2;
                    List<Object> lae = la.elements();
                    List<Object> rae = ra.elements();
                    if (lae.size() != rae.size()) {
                        throw new UnsupportedOperationException();
                    }
                    Iterator li = lae.iterator();
                    Iterator ri = rae.iterator();
                    Array result = new Array();
                    int i = 0;
                    while (i < lae.size()) {
                        double ld = (Double)li.next();
                        double rd = (Double)ri.next();
                        result.addElement(this.evaluate(ld, rd));
                        ++i;
                    }
                    return result;
                }
                throw new IllegalStateException();
            }
        });
        model.functions.put("xidz", new Fn1(3){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double p1 = (Double)environment.getValue(0);
                Double p2 = (Double)environment.getValue(1);
                Double x = (Double)environment.getValue(2);
                if (Math.abs(p2) < 1.0E-12) {
                    return x;
                }
                return p1 / p2;
            }
        });
        model.functions.put("availabilityExternal", new Fn1(4){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double numberOfDays = (Double)environment.getValue(0);
                Double numberOfDesigners = (Double)environment.getValue(1);
                Double rseed = (Double)environment.getValue(2);
                Array availability = (Array)environment.getValue(3);
                Array result = new Array();
                int i = 0;
                while (i < numberOfDays.intValue() * numberOfDesigners.intValue()) {
                    result.addElement(Math.random());
                    ++i;
                }
                return result;
            }
        });
        model.functions.put("pre", new Fn1(1){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                return (Double)environment.getValue(0);
            }
        });
        model.functions.put("fill", new Fn1(3){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double value = (Double)environment.getValue(0);
                Double dim1 = (Double)environment.getValue(1);
                if (argc == 2) {
                    Array result = new Array();
                    int i = 0;
                    while (i < dim1.intValue()) {
                        result.addElement(value);
                        ++i;
                    }
                    return result;
                }
                if (argc == 3) {
                    Double dim2 = (Double)environment.getValue(2);
                    Array result = new Array();
                    int i = 0;
                    while (i < dim1.intValue()) {
                        Array array = new Array();
                        int j = 0;
                        while (j < dim2.intValue()) {
                            array.addElement(value);
                            ++j;
                        }
                        result.addElement(array);
                        ++i;
                    }
                    return result;
                }
                throw new UnsupportedOperationException();
            }
        });
        model.functions.put("randomNumber", new FnRandom(2){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double seed = (Double)environment.getValue(0);
                if (this.random == null) {
                    this.random = new Random(Double.doubleToLongBits(seed));
                }
                return this.random.nextDouble();
            }
        });
        model.functions.put("randomUniform", new FnRandom(4){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double min = (Double)environment.getValue(0);
                Double max = (Double)environment.getValue(1);
                Double seed = (Double)environment.getValue(2);
                if (this.random == null) {
                    this.random = new Random(Double.doubleToLongBits(seed));
                }
                return this.random.nextDouble() * (max - min) + min;
            }
        });
        model.functions.put("randomNormal", new FnRandom(6){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Double min = (Double)environment.getValue(0);
                Double max = (Double)environment.getValue(1);
                Double mean = (Double)environment.getValue(2);
                Double stdev = (Double)environment.getValue(3);
                Double seed = (Double)environment.getValue(4);
                if (this.random == null) {
                    this.random = new Random(Double.doubleToLongBits(seed));
                }
                return NormalDistribution.uniformVariableToNormal(min, max, mean, stdev, this.random.nextDouble());
            }
        });
        model.functions.put("initial", new Fn1(0){

            @Override
            public Object evaluate(IEnvironment _environment, int argc) {
                return _environment.getSystem().initial();
            }
        });
        model.functions.put("noEvent", new Fn1(1){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                return environment.getValue(0);
            }
        });
        model.functions.put("integer", new Fn1(1){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Object value = environment.getValue(0);
                if (value instanceof Double) {
                    double d = ((Double)value).intValue();
                    return d;
                }
                if (value instanceof Array) {
                    return ((Array)value).copy(new Array.Modifier(){

                        @Override
                        public Object modify(Object o) {
                            if (o instanceof Double) {
                                double d = ((Double)o).intValue();
                                return d;
                            }
                            throw new IllegalStateException();
                        }
                    });
                }
                throw new IllegalStateException();
            }
        });
        model.functions.put("sum", new Fn1(1){

            public double sum(Array a) {
                double res = 0.0;
                for (Object element : a.elements()) {
                    if (element instanceof Array) {
                        res += this.sum((Array)element);
                        continue;
                    }
                    if (element instanceof Double) {
                        res += ((Double)element).doubleValue();
                        continue;
                    }
                    throw new IllegalStateException("Tried to sum a non-numerical array");
                }
                return res;
            }

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Object value = environment.getValue(0);
                if (value instanceof Double) {
                    return (Double)value;
                }
                Array arr = (Array)value;
                return this.sum(arr);
            }
        });
        model.functions.put("ones", new Fn1(-1){

            private Array make(int[] dims, int pos) {
                Array result = new Array();
                int d = dims[pos];
                if (pos == dims.length - 1) {
                    int i = 0;
                    while (i < d) {
                        result.addElement(1.0);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < d) {
                        result.addElement(this.make(dims, pos + 1));
                        ++i;
                    }
                }
                return result;
            }

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                int[] dims = new int[argc];
                int i = 0;
                while (i < argc) {
                    Double d = (Double)environment.getValue(i);
                    dims[i] = d.intValue();
                    ++i;
                }
                return this.make(dims, 0);
            }
        });
        model.functions.put("zeros", new Fn1(-1){

            private Array make(int[] dims, int pos) {
                Array result = new Array();
                int d = dims[pos];
                if (pos == dims.length - 1) {
                    int i = 0;
                    while (i < d) {
                        result.addElement(0.0);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < d) {
                        result.addElement(this.make(dims, pos + 1));
                        ++i;
                    }
                }
                return result;
            }

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                int[] dims = new int[argc];
                int i = 0;
                while (i < argc) {
                    Double d = (Double)environment.getValue(i);
                    dims[i] = d.intValue();
                    ++i;
                }
                return this.make(dims, 0);
            }
        });
        model.functions.put("transpose", new Fn1(1){

            @Override
            public Object evaluate(IEnvironment environment, int argc) {
                Array array = (Array)environment.getValue(0);
                return array.transposed();
            }
        });
        model.functions.put("delay", new Fn1(4){

            @Override
            public Object evaluate(IEnvironment _environment, int argc) {
                String ident = (String)_environment.getValue(0);
                Double value = (Double)_environment.getValue(1);
                Double p1 = (Double)_environment.getValue(2);
                ISystem system = _environment.getSystem();
                TreeMap<Double, Double> history = system.getHistory(ident);
                double time = system.time();
                history.put(time, value);
                Double key = history.ceilingKey(time - p1);
                return history.get(key);
            }
        });
        model.functions.put("cat", new Fn1(10){

            @Override
            public Object evaluate(IEnvironment _environment, int argc) {
                Double dim = (Double)_environment.getValue(0);
                Array array = new Array();
                int i = 1;
                while (i < argc) {
                    Object ar = _environment.getValue(i);
                    if (ar instanceof Array) {
                        Array a = (Array)ar;
                        for (Object o : a.elements()) {
                            array.addElement(o);
                        }
                    } else {
                        throw new IllegalStateException();
                    }
                    ++i;
                }
                return array;
            }
        });
    }

    @Override
    public TreeMap<Double, Double> getHistory(String ident) {
        TreeMap<Double, Double> result = this.history.get(ident);
        if (result == null) {
            result = new TreeMap();
            this.history.put(ident, result);
        }
        return result;
    }

    @Override
    public Object getValue(int key) {
        return this.valueTable[key];
    }

    @Override
    public void put(int key, Object value) {
        this.valueTable[key] = value;
    }

    @Override
    public void put(String key, Object value) {
        this.named.put(key, value);
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public int offset() {
        return this.size;
    }

    @Override
    public ISystem getSystem() {
        return this;
    }

    @Override
    public boolean initial() {
        return this.initial;
    }

    @Override
    public Object evaluateFunction(IEnvironment environment, String name, ArgumentList args) {
        return this.model.evaluateFunction(environment, name, args);
    }

    @Override
    public double time() {
        return this.time;
    }

    public void addIndexed(int[] dimensions, ArrayList<String> keys, String prefix, int d) {
        if (d == dimensions.length) {
            keys.add(prefix);
            return;
        }
        String prefix2 = prefix;
        if (d == 0) {
            prefix2 = String.valueOf(prefix2) + "[";
        }
        if (d > 0) {
            prefix2 = String.valueOf(prefix2) + ",";
        }
        int i = 0;
        while (i < dimensions[d]) {
            String prefix3 = String.valueOf(prefix2) + (i + 1);
            if (d + 1 == dimensions.length) {
                prefix3 = String.valueOf(prefix3) + "]";
            }
            this.addIndexed(dimensions, keys, prefix3, d + 1);
            ++i;
        }
    }

    public int length(int[] dimension) {
        int result = 1;
        int[] nArray = dimension;
        int n = dimension.length;
        int n2 = 0;
        while (n2 < n) {
            int d = nArray[n2];
            result *= d;
            ++n2;
        }
        return result;
    }

    public void addVariable(String name, int index, int[] dimensions, ArrayList<String> keys, TIntArrayList indices, Set<String> used) {
        if (!used.add(name)) {
            return;
        }
        if (dimensions == null) {
            keys.add(name);
            indices.add(index);
        } else {
            this.addIndexed(dimensions, keys, name, 0);
            int i = 0;
            while (i < this.length(dimensions)) {
                indices.add(index + i);
                ++i;
            }
        }
    }

    public void addVariable(Variable var, ArrayList<String> keys, TIntArrayList indices, Set<String> used) {
        this.addVariable(var.base.name, var.base.index, var.base.dimensions, keys, indices, used);
    }

    public String[] getValueKeyArray() {
        ArrayList<String> keys = new ArrayList<String>();
        TIntArrayList indices = new TIntArrayList();
        HashSet<String> used = new HashSet<String>();
        int i = 0;
        while (i < this.model.assignmentArray.length) {
            this.addVariable(this.model.assignmentArray[i].target, keys, indices, used);
            ++i;
        }
        i = 0;
        while (i < this.model.derivativeArray.length) {
            this.addVariable(this.model.derivativeArray[i].target, keys, indices, used);
            ++i;
        }
        i = 0;
        while (i < this.model.parameterArray.length) {
            this.addVariable(this.model.parameterArray[i].variable, keys, indices, used);
            ++i;
        }
        for (Map.Entry<String, VariableBase> entry : this.model.copies.entrySet()) {
            this.addVariable(entry.getKey(), entry.getValue().index, entry.getValue().dimensions, keys, indices, used);
        }
        this.valueArray = new double[keys.size()];
        this.keyIndexMap.clear();
        i = 0;
        while (i < keys.size()) {
            String key = keys.get(i);
            int index = indices.get(i);
            this.keyIndexMap.put((Object)key, index);
            ++i;
        }
        this.valueIndices = new int[keys.size()];
        this.getValueIndices();
        return keys.toArray(new String[keys.size()]);
    }

    public int[] getValueIndices() {
        int index;
        Variable v;
        int offset = 0;
        HashSet<String> used = new HashSet<String>();
        int i = 0;
        while (i < this.model.assignmentArray.length) {
            v = this.model.assignmentArray[i].target;
            if (used.add(v.base.name)) {
                index = 0;
                while (index < v.base.dimension()) {
                    this.valueIndices[offset++] = v.base.index(this, null) + index;
                    ++index;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.model.derivativeArray.length) {
            v = this.model.derivativeArray[i].target;
            if (used.add(v.base.name)) {
                index = 0;
                while (index < v.base.dimension()) {
                    this.valueIndices[offset++] = v.base.index(this, null) + index;
                    ++index;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.model.parameterArray.length) {
            v = this.model.parameterArray[i].variable;
            if (used.add(v.base.name)) {
                index = 0;
                while (index < v.base.dimension()) {
                    this.valueIndices[offset++] = v.base.index(this, null) + index;
                    ++index;
                }
            }
            ++i;
        }
        for (Map.Entry<String, VariableBase> entry : this.model.copies.entrySet()) {
            VariableBase base = entry.getValue();
            if (!used.add(entry.getKey())) continue;
            int index2 = 0;
            while (index2 < base.dimension()) {
                this.valueIndices[offset++] = base.index(this, null) + index2;
                ++index2;
            }
        }
        return this.valueIndices;
    }

    public double[] getValueArray() {
        int i = 0;
        while (i < this.valueArray.length) {
            Double value = (Double)this.getValue(this.valueIndices[i]);
            if (value == null) {
                value = 0.0;
            }
            this.valueArray[i] = value;
            ++i;
        }
        return this.valueArray;
    }

    @Override
    public Object getNamedValue(String key) {
        return this.named.get(key);
    }

    public void setValue(String key, double value) {
        int index = this.keyIndexMap.get((Object)key);
        this.put(index, (Object)value);
    }

    public void setAssigned(Object ass) {
        this.assigned.add(ass);
    }

    public boolean isAssigned(Object o) {
        return this.assigned.contains(o);
    }
}

