/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.synchronization;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.genericrelation.DependencyChanges;
import org.simantics.db.layer0.request.ModelInstances;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.utils.StructuralChangeVisitor;
import org.simantics.structural2.utils.StructuralMetadataUtils;

public class StructuralChangeFlattener {
    private static Variable[] EMPTY_VARIABLE_ARRAY = new Variable[0];

    public static TObjectIntHashMap<Variable> getModifiedComponents(ReadGraph graph, Variable rootVariable, long fromRevision) throws DatabaseException {
        Visitor visitor = new Visitor(graph, rootVariable);
        StructuralMetadataUtils.visitStructuralChangesFrom((ReadGraph)graph, (Resource)Variables.getModel((ReadGraph)graph, (Variable)rootVariable), (long)fromRevision, (StructuralChangeVisitor)visitor);
        return visitor.modifiedComponents;
    }

    public static TObjectIntHashMap<Variable> getModifiedComponents(ReadGraph graph, Variable rootVariable, DependencyChanges.Change[] changes) throws DatabaseException {
        Visitor visitor = new Visitor(graph, rootVariable);
        StructuralMetadataUtils.visitStructuralChangesFrom((ReadGraph)graph, (Resource)Variables.getModel((ReadGraph)graph, (Variable)rootVariable), (DependencyChanges.Change[])changes, (StructuralChangeVisitor)visitor);
        return visitor.modifiedComponents;
    }

    private static class Visitor
    implements StructuralChangeVisitor {
        Variable rootVariable;
        Resource rootResource;
        Resource model;
        THashMap<Resource, Variable[]> visitedVariables = new THashMap();
        Layer0 L0;
        StructuralResource2 STR;
        TObjectIntHashMap<Variable> modifiedComponents = new TObjectIntHashMap();

        public Visitor(ReadGraph graph, Variable rootVariable) throws DatabaseException {
            this.rootVariable = rootVariable;
            this.rootResource = rootVariable.getRepresents(graph);
            this.model = Variables.getModel((ReadGraph)graph, (Variable)rootVariable);
            this.L0 = Layer0.getInstance((ReadGraph)graph);
            this.STR = StructuralResource2.getInstance((ReadGraph)graph);
        }

        public void visitComponentChange(ReadGraph graph, Resource component, boolean componentItselfModified) throws DatabaseException {
            Variable[] variables = (Variable[])this.visitedVariables.get((Object)component);
            if (variables == null) {
                variables = this.visitUnseenComponent(graph, component);
                this.visitedVariables.put((Object)component, (Object)variables);
            }
            if (componentItselfModified) {
                Variable[] variableArray = variables;
                int n = variables.length;
                int n2 = 0;
                while (n2 < n) {
                    Variable variable = variableArray[n2];
                    this.modifiedComponents.put((Object)variable, 2);
                    ++n2;
                }
            } else {
                Variable[] variableArray = variables;
                int n = variables.length;
                int n3 = 0;
                while (n3 < n) {
                    Variable variable = variableArray[n3];
                    this.modifiedComponents.putIfAbsent((Object)variable, 1);
                    ++n3;
                }
            }
        }

        private Variable[] visitUnseenComponent(ReadGraph graph, Resource component) throws DatabaseException {
            if (component.equals(this.rootResource)) {
                return new Variable[]{this.rootVariable};
            }
            Resource componentType = graph.getPossibleObject(component, this.STR.Defines);
            if (componentType != null) {
                ArrayList<Variable> result = new ArrayList<Variable>();
                Map instances = (Map)graph.syncRequest((Read)new ModelInstances(this.model, componentType), (AsyncProcedure)TransientCacheAsyncListener.instance());
                for (Resource instance : instances.values()) {
                    this.visitComponentChange(graph, instance, false);
                    Variable[] variableArray = (Variable[])this.visitedVariables.get((Object)instance);
                    int n = variableArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Variable variable = variableArray[n2];
                        result.add(variable);
                        ++n2;
                    }
                }
                if (result.isEmpty()) {
                    return EMPTY_VARIABLE_ARRAY;
                }
                return result.toArray(new Variable[result.size()]);
            }
            Resource parent = graph.getPossibleObject(component, this.L0.PartOf);
            String name = (String)graph.getPossibleRelatedValue(component, this.L0.HasName, (Binding)Bindings.STRING);
            if (parent == null || name == null || !graph.isInstanceOf(component, this.STR.Component)) {
                return EMPTY_VARIABLE_ARRAY;
            }
            this.visitComponentChange(graph, parent, false);
            Variable[] parentCorrespondences = (Variable[])this.visitedVariables.get((Object)parent);
            ArrayList<Variable> result = new ArrayList<Variable>(parentCorrespondences.length);
            Variable[] variableArray = parentCorrespondences;
            int n = parentCorrespondences.length;
            int n3 = 0;
            while (n3 < n) {
                Variable parentCorrespondence = variableArray[n3];
                Variable correspondence = parentCorrespondence.getPossibleChild(graph, name);
                if (correspondence != null) {
                    result.add(correspondence);
                }
                ++n3;
            }
            if (result.isEmpty()) {
                return EMPTY_VARIABLE_ARRAY;
            }
            return result.toArray(new Variable[result.size()]);
        }
    }
}

