/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphviz.continuation;

import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import org.simantics.graphviz.continuation.Continuation;

public abstract class Computation<T> {
    T result;
    Exception exception;
    ArrayList<Continuation<T>> continuations = new ArrayList();
    CountDownLatch doneGate = new CountDownLatch(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContinuation(Continuation<T> continuation) {
        CountDownLatch countDownLatch = this.doneGate;
        synchronized (countDownLatch) {
            if (this.doneGate.getCount() == 0L) {
                if (this.exception == null) {
                    continuation.succeeded(this.result);
                } else {
                    continuation.failed(this.exception);
                }
            } else {
                this.continuations.add(continuation);
            }
        }
    }

    public boolean isDone() {
        return this.doneGate.getCount() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void failWith(Exception exception) {
        ArrayList<Continuation<T>> cs;
        this.exception = exception;
        CountDownLatch countDownLatch = this.doneGate;
        synchronized (countDownLatch) {
            cs = this.continuations;
            this.continuations = null;
            this.doneGate.countDown();
        }
        if (cs != null) {
            for (Continuation<T> continuation : cs) {
                continuation.failed(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doneWith(T result) {
        ArrayList<Continuation<T>> cs;
        this.result = result;
        CountDownLatch countDownLatch = this.doneGate;
        synchronized (countDownLatch) {
            cs = this.continuations;
            this.continuations = null;
            this.doneGate.countDown();
        }
        if (cs != null) {
            for (Continuation<T> continuation : cs) {
                continuation.succeeded(result);
            }
        }
    }

    public void cancel() {
        this.failWith(new CancellationException());
    }

    public T get() throws Exception {
        this.doneGate.await();
        if (this.exception != null) {
            throw this.exception;
        }
        return this.result;
    }
}

