/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.ui.internal;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.procore.ui.internal.UI;
import org.simantics.db.procore.ui.internal.Util;
import org.simantics.db.server.Auxiliary;
import org.simantics.db.server.ProCoreException;

class HandlerUtil {
    private static String NL = System.getProperty("line.separator");

    HandlerUtil() {
    }

    private static boolean isFolder(Shell shell, File dbFolder, String title) {
        if (dbFolder.isDirectory()) {
            return true;
        }
        MessageDialog.openWarning((Shell)shell, (String)title, (String)("Database folder does not exist. folder=" + dbFolder));
        return false;
    }

    public static boolean saveWithQuestion(Shell shell, File dbFolder, String title, String msg) {
        if (!HandlerUtil.isFolder(shell, dbFolder, title)) {
            return false;
        }
        String question = String.valueOf(msg != null ? String.valueOf(msg) + NL : "") + "Do you want to save database?" + NL + "folder=" + dbFolder;
        boolean yes = MessageDialog.openQuestion((Shell)shell, (String)title, (String)question);
        if (!yes) {
            return true;
        }
        final class SaveDatabase
        extends ExecutorDatabase {
            Path saveFolder;

            SaveDatabase(File dbFolder) {
                super(dbFolder);
                this.beginMessage = "Saving database.";
                this.okMessage = "Database has been saved.";
                this.failMessage = "Failed to save database.";
                this.cancelMessage = "Save cancelled.";
            }

            @Override
            public void execute() throws Throwable {
                this.saveFolder = Auxiliary.saveDatabase((File)this.dbFolder);
                if (this.saveFolder == null || !Files.isDirectory(this.saveFolder, new LinkOption[0])) {
                    throw new ProCoreException("Save folder not ok.");
                }
            }

            @Override
            public String getMessage() {
                return String.valueOf(NL) + "folder=" + this.saveFolder;
            }
        }
        SaveDatabase save = new SaveDatabase(dbFolder);
        HandlerUtil.execute(shell, save);
        save.showDone(shell);
        return save.ok;
    }

    static boolean saveWithCheck(Shell shell, File dbFolder, String title, String msg) {
        boolean ok = HandlerUtil.saveWithQuestion(shell, dbFolder, title, msg);
        if (ok) {
            return true;
        }
        String question = "Save failed. Do you want me to contine?";
        return Util.confirm(shell, title, question);
    }

    public static boolean delete(Shell shell, File dbFolder, String title, String msg) {
        if (!HandlerUtil.isFolder(shell, dbFolder, title)) {
            return false;
        }
        String question = String.valueOf(msg != null ? String.valueOf(msg) + NL : "") + "Do you want to delete database?" + NL + "folder=" + dbFolder;
        boolean yes = MessageDialog.openQuestion((Shell)shell, (String)title, (String)question);
        if (!yes) {
            return false;
        }
        HandlerUtil.saveWithQuestion(shell, dbFolder, title, null);
        final class DeleteDatabase
        extends ExecutorDatabase {
            DeleteDatabase(File dbFolder) {
                super(dbFolder);
                this.beginMessage = "Deleting database.";
                this.okMessage = "Database has been deleted.";
                this.failMessage = "Failed to delete database.";
                this.cancelMessage = "Delete cancelled.";
            }

            @Override
            public void execute() throws Throwable {
                Auxiliary.deleteDatabase((File)this.dbFolder);
            }
        }
        DeleteDatabase delete = new DeleteDatabase(dbFolder);
        HandlerUtil.execute(shell, delete);
        delete.showDone(shell);
        return delete.ok;
    }

    public static boolean purge(Shell shell, File dbFolder, String title, String msg) {
        String question;
        boolean yes;
        if (!HandlerUtil.isFolder(shell, dbFolder, title)) {
            return false;
        }
        try {
            if (Auxiliary.purgeDatabaseDone((File)dbFolder)) {
                MessageDialog.openInformation((Shell)shell, (String)title, (String)("Database already purged." + NL + "folder=" + dbFolder));
                return true;
            }
        }
        catch (ProCoreException e) {
            Logger.defaultLogError((String)"Failed to query database purge state.", (Throwable)e);
        }
        if (!(yes = MessageDialog.openQuestion((Shell)shell, (String)title, (String)(question = String.valueOf(msg != null ? String.valueOf(msg) + NL : "") + "Do you want to purge database?")))) {
            return false;
        }
        return HandlerUtil.purgeWithSave(shell, dbFolder, title);
    }

    private static boolean purgeWithSave(Shell shell, File dbFolder, String title) {
        boolean ok = HandlerUtil.saveWithCheck(shell, dbFolder, title, null);
        if (!ok) {
            return false;
        }
        final class PurgeDatabase
        extends ExecutorDatabase {
            PurgeDatabase(File dbFolder) {
                super(dbFolder);
                this.beginMessage = "Purging database.";
                this.okMessage = "Database has been purged.";
                this.failMessage = "Failed to purge database.";
                this.cancelMessage = "Purge cancelled.";
            }

            @Override
            public void execute() throws Throwable {
                Auxiliary.purgeDatabase((File)this.dbFolder);
            }
        }
        PurgeDatabase purge = new PurgeDatabase(dbFolder);
        HandlerUtil.execute(shell, purge);
        purge.showDone(shell);
        return purge.ok;
    }

    public static boolean recoverFromGuardFileVersion(Shell shell, File dbFolder, String title, String msg) throws ProCoreException {
        String question = String.valueOf(msg != null ? msg : "") + NL + "Guard file version mismatch indicates that the database was made with different server version." + "It would be best to open the database with the same version it was made.";
        MessageDialog.openWarning((Shell)shell, (String)title, (String)question);
        return false;
    }

    public static boolean recoverFromDatabaseLastExit(Shell shell, File dbFolder, String title, String msg) throws ProCoreException {
        String message = String.valueOf(msg != null ? msg : "") + NL + "What should I try to do?";
        ArrayList<Util.Choice> choices = new ArrayList<Util.Choice>();
        choices.add(new Util.Choice("Cancel", "Cancel i.e. do nothing. Choose this if you want to manually analyze and correct the situation. This is the safest choice."));
        choices.add(new Util.Choice("Ignore", "Ignore the exit status. Choose this if you do not know what you are doing. This is fast way to recover and is the safest choice except for cancel."));
        choices.add(new Util.Choice("Remove", "Remove history. Choose this you know what you are doing. This is fast way to recover but can leave tricky semantic errors in the database. Furhermore, depending on the reason for the non clean exit status, this can fail and corrupt data. However, depending on how the client and/or server died, this could be the right choice."));
        choices.add(new Util.Choice("Recover", "Recover using journal. Choose this if you are willing to wait and know that the other choices won't work."));
        Util.Choice[] t = new Util.Choice[choices.size()];
        int choice = Util.select(shell, title, message, choices.toArray(t), 0);
        switch (choice) {
            default: {
                return false;
            }
            case 1: {
                return HandlerUtil.ignoreExitStatusWithSave(shell, dbFolder, title);
            }
            case 2: {
                return HandlerUtil.purgeWithSave(shell, dbFolder, title);
            }
            case 3: 
        }
        return HandlerUtil.recoverFromJournalWithSave(shell, dbFolder, title);
    }

    public static boolean ignoreExitStatusWithSave(Shell shell, File dbFolder, String title) {
        boolean ok = HandlerUtil.saveWithCheck(shell, dbFolder, title, null);
        if (!ok) {
            return false;
        }
        final class IgnoreExitDatabase
        extends ExecutorDatabase {
            IgnoreExitDatabase(File dbFolder) {
                super(dbFolder);
                this.beginMessage = "Ignoring last exit status.";
                this.okMessage = "Ignore done.";
                this.failMessage = "Failed to start.";
                this.cancelMessage = "Ignore cancelled.";
            }

            @Override
            public void execute() throws Throwable {
                Auxiliary.ignoreExit((File)this.dbFolder);
            }
        }
        IgnoreExitDatabase recover = new IgnoreExitDatabase(dbFolder);
        HandlerUtil.execute(shell, recover);
        recover.showDone(shell);
        return recover.ok;
    }

    public static boolean ignoreProtocolVersionWithSave(Shell shell, File dbFolder, String title) {
        boolean ok = HandlerUtil.saveWithCheck(shell, dbFolder, title, null);
        if (!ok) {
            return false;
        }
        final class IgnoreProtocolDatabase
        extends ExecutorDatabase {
            IgnoreProtocolDatabase(File dbFolder) {
                super(dbFolder);
                this.beginMessage = "Ignoring protocol version mismatch.";
                this.okMessage = "Ignore done.";
                this.failMessage = "Failed to start.";
                this.cancelMessage = "Ignore cancelled.";
            }

            @Override
            public void execute() throws Throwable {
                Auxiliary.ignoreProtocol((File)this.dbFolder);
            }
        }
        IgnoreProtocolDatabase ignore = new IgnoreProtocolDatabase(dbFolder);
        HandlerUtil.execute(shell, ignore);
        ignore.showDone(shell);
        return ignore.ok;
    }

    public static boolean recoverFromProtocol(Shell shell, File dbFolder, String title, String msg) throws ProCoreException {
        String question = String.valueOf(msg != null ? msg : "") + NL + "Protocol version mismatch indicates that server and client versions differ." + " It would be best to open the database using the same server and client version." + " But if you insist I can ignore the mismatch and try to muddle along." + " If this works then you should export the data and get matching client and server versions." + " Otherwise there could later be strange errors caused by this version mismatch." + " Shoud I try?";
        boolean yes = Util.openDefaultNo(shell, title, question, 3);
        if (!yes) {
            return false;
        }
        return HandlerUtil.ignoreProtocolVersionWithSave(shell, dbFolder, title);
    }

    public static boolean recoverFromDatabaseVersion(Shell shell, File dbFolder, String title, String msg) throws ProCoreException {
        String question = String.valueOf(msg != null ? msg : "") + NL + "Database version mismatch indicates that the database was made with different server version." + " It would be best to open the database with the same version it was made." + " But if you insist I can try to recover database from journal.";
        boolean yes = Util.openDefaultNo(shell, title, question, 3);
        if (!yes) {
            return false;
        }
        return HandlerUtil.recoverFromJournalWithSave(shell, dbFolder, title);
    }

    public static boolean recoverFromJournal(Shell shell, File dbFolder, String title, String msg) throws ProCoreException {
        if (!HandlerUtil.isFolder(shell, dbFolder, title)) {
            return false;
        }
        if (!Auxiliary.canReadJournal((File)dbFolder)) {
            MessageDialog.openWarning((Shell)shell, (String)title, (String)("Journal file does not exist or isn't readable." + NL + "folder=" + dbFolder));
            return false;
        }
        String question = String.valueOf(msg != null ? msg : "") + NL + "Do you want me to try to recreate the database from journal?";
        boolean yes = MessageDialog.openQuestion((Shell)shell, (String)title, (String)question);
        if (!yes) {
            return false;
        }
        return HandlerUtil.recoverFromJournalWithSave(shell, dbFolder, title);
    }

    public static boolean recoverFromJournalWithSave(Shell shell, File dbFolder, String title) {
        boolean ok = HandlerUtil.saveWithCheck(shell, dbFolder, title, null);
        if (!ok) {
            return false;
        }
        final class RecoverDatabase
        extends ExecutorDatabase {
            RecoverDatabase(File dbFolder) {
                super(dbFolder);
                this.beginMessage = "Recovering database.";
                this.okMessage = "Database has been recovered.";
                this.failMessage = "Failed to recover database.";
                this.cancelMessage = "Recovery cancelled.";
            }

            @Override
            public void execute() throws Throwable {
                Auxiliary.replaceFromJournal((File)this.dbFolder);
            }
        }
        RecoverDatabase recover = new RecoverDatabase(dbFolder);
        HandlerUtil.execute(shell, recover);
        recover.showDone(shell);
        return recover.ok;
    }

    private static void sleep(long millsec) throws InterruptedException {
        Display display = UI.getDisplay();
        boolean isUIThread = display == null ? false : Thread.currentThread() == display.getThread();
        Thread.sleep(100L);
        if (!isUIThread) {
            return;
        }
        int count = 0;
        while (++count < 1000 && display.readAndDispatch()) {
        }
    }

    private static void execute(Shell shell, final Executor executor) {
        final Thread thread = new Thread(executor);
        thread.start();
        IRunnableWithProgress progress = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask(executor.getMessageBegin(), -1);
                    while (!monitor.isCanceled() && !executor.isDone()) {
                        monitor.worked(1);
                        HandlerUtil.sleep(100L);
                    }
                    if (executor.isDone()) {
                        return;
                    }
                    executor.setCancelled();
                    thread.interrupt();
                    monitor.subTask("Waiting for cancellation to finish.");
                    while (!executor.isDone()) {
                        HandlerUtil.sleep(100L);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        boolean fork = executor.isForkable();
        boolean cancelable = executor.isCancelable();
        try {
            new ProgressMonitorDialog(shell).run(fork, cancelable, progress);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    static interface Executor
    extends Runnable {
        public String getMessageBegin();

        public String getMessageCancel();

        public String getMessageFail(Throwable var1);

        public String getMessageFail();

        public String getMessageOk();

        public boolean isDone();

        public boolean isForkable();

        public boolean isCancelable();

        public void execute() throws Throwable;

        public void setCancelled();

        public void setDone();

        public void showDone(Shell var1);
    }

    static abstract class ExecutorBase
    implements Executor {
        protected String beginMessage = "Task begin.";
        protected String okMessage = "Task ok.";
        protected String failMessage = "Task failed.";
        protected String cancelMessage = "Task cancelled.";
        protected boolean done = false;
        protected boolean ok = false;
        protected boolean cancelled = false;
        protected boolean forkable = true;
        protected boolean cancelable = false;
        protected Throwable throwable = null;

        ExecutorBase() {
        }

        @Override
        public void run() {
            try {
                try {
                    this.execute();
                    this.ok = true;
                }
                catch (Throwable t) {
                    this.throwable = t;
                    this.done = true;
                }
            }
            finally {
                this.done = true;
            }
        }

        @Override
        public String getMessageBegin() {
            return this.beginMessage;
        }

        @Override
        public String getMessageCancel() {
            return this.cancelMessage;
        }

        @Override
        public String getMessageFail(Throwable throwable) {
            return String.valueOf(this.failMessage) + NL + throwable.getMessage();
        }

        @Override
        public String getMessageFail() {
            return this.failMessage;
        }

        @Override
        public String getMessageOk() {
            return this.okMessage;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public void setCancelled() {
            this.cancelled = true;
        }

        @Override
        public void setDone() {
            this.done = true;
        }

        @Override
        public boolean isForkable() {
            return this.forkable;
        }

        @Override
        public boolean isCancelable() {
            return this.cancelable;
        }

        @Override
        public void showDone(Shell shell) {
            if (this.throwable != null) {
                Util.showError(shell, this.getMessageFail(this.throwable));
            } else if (this.ok) {
                Util.showInfo(shell, this.getMessageOk());
            } else if (this.cancelled) {
                Util.showInfo(shell, this.getMessageCancel());
            } else {
                Util.showWarning(shell, this.getMessageFail());
            }
        }
    }

    static abstract class ExecutorDatabase
    extends ExecutorBase {
        protected final File dbFolder;

        ExecutorDatabase(File dbFolder) {
            this.dbFolder = dbFolder;
        }

        String getMessage() {
            return String.valueOf(NL) + "folder=" + this.dbFolder;
        }

        @Override
        public String getMessageBegin() {
            return String.valueOf(super.getMessageBegin()) + this.getMessage();
        }

        @Override
        public String getMessageCancel() {
            return String.valueOf(super.getMessageCancel()) + this.getMessage();
        }

        @Override
        public String getMessageFail(Throwable t) {
            return String.valueOf(super.getMessageFail(t)) + this.getMessage();
        }

        @Override
        public String getMessageOk() {
            return String.valueOf(super.getMessageOk()) + this.getMessage();
        }
    }
}

