/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.GraphSession;
import fi.vtt.simantics.procore.internal.UpdateClusterFunction;
import java.util.Arrays;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.service.Bytes;
import org.simantics.db.service.ClusterUID;

class ClusterChange2 {
    public static final int VERSION = 2;
    public static final byte SET_IMMUTABLE_OPERATION = 1;
    public static final byte UNDO_VALUE_OPERATION = 2;
    public static final byte SET_DELETED_OPERATION = 3;
    private static final int INCREMENT = 1024;
    private boolean dirty = false;
    private byte[] bytes;
    private int byteIndex;
    private ClusterUID clusterUID;

    ClusterChange2(ClusterUID clusterUID, ClusterImpl cluster) {
        this.clusterUID = clusterUID;
        this.init();
    }

    void init() {
        this.dirty = false;
        this.bytes = new byte[1024];
        this.byteIndex = 0;
        this.addInt(0);
        this.addInt(2);
        this.byteIndex = this.clusterUID.toByte(this.bytes, 8);
    }

    boolean isDirty() {
        return this.dirty;
    }

    void flush(GraphSession graphSession) {
        if (!this.dirty) {
            return;
        }
        Bytes.writeLE((byte[])this.bytes, (int)0, (int)(this.byteIndex - 4));
        byte[] ops = Arrays.copyOf(this.bytes, this.byteIndex);
        graphSession.updateCluster(new UpdateClusterFunction(ops));
        this.init();
    }

    void setImmutable(boolean immutable) {
        this.dirty = true;
        this.addByte((byte)1);
        this.addByte((byte)(immutable ? -1 : 0));
    }

    void setDeleted(boolean deleted) {
        this.dirty = true;
        this.addByte((byte)3);
        this.addByte((byte)(deleted ? -1 : 0));
    }

    void undoValueEx(int resourceIndex) {
        this.dirty = true;
        this.addByte((byte)2);
        this.addInt(resourceIndex);
    }

    private final void checkSpace(int len) {
        if (this.bytes.length - this.byteIndex > len) {
            return;
        }
        this.bytes = Arrays.copyOf(this.bytes, this.bytes.length + len + 1024);
    }

    private final void addByte(byte value) {
        this.checkSpace(1);
        this.bytes[this.byteIndex++] = value;
    }

    private final void addInt(int value) {
        this.checkSpace(4);
        Bytes.writeLE((byte[])this.bytes, (int)this.byteIndex, (int)value);
        this.byteIndex += 4;
    }
}

