/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.Transaction;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.layer0.DatabaseManagementResource;

public class GraphBundle
implements Comparable<GraphBundle> {
    static String ID_PATTERN_STRING = "[a-zA-Z_0-9\\-]+(?:\\.[a-zA-Z_0-9\\-]+)*";
    static String VERSION_PATTERN_STRING = "(\\d+).(\\d+).(\\d+).([a-zA-Z_0-9\\-]+)";
    static Pattern ID_PATTERN = Pattern.compile(ID_PATTERN_STRING);
    static Pattern VERSION_PATTERN = Pattern.compile(VERSION_PATTERN_STRING);
    static Pattern VERSIONED_ID_PATTERN = Pattern.compile("(" + ID_PATTERN_STRING + ")/" + VERSION_PATTERN_STRING);
    String name;
    TransferableGraph1 graph;
    Resource resource;
    int hashcode;
    String id;
    int major;
    int minor;
    int service;
    String qualifier;
    long[] resourceArray;
    boolean immutable = true;

    GraphBundle() {
    }

    public GraphBundle(String name, TransferableGraph1 data, String versionedId) throws RuntimeBindingException {
        try {
            Matcher m = VERSIONED_ID_PATTERN.matcher(versionedId);
            if (!m.matches()) {
                throw new IllegalArgumentException("Illegal VersionId \"" + versionedId + "\", <id>/<major.minor.micro.qualifier> is expected.");
            }
            Binding binding = Bindings.getBindingUnchecked(TransferableGraph1.class);
            this.name = name;
            this.graph = data;
            this.hashcode = data != null ? binding.hashValue((Object)data) : 0;
            this.id = m.group(1);
            this.major = Integer.valueOf(m.group(2));
            this.minor = Integer.valueOf(m.group(3));
            if (m.group(4) != null) {
                this.service = Integer.valueOf(m.group(4));
            }
            this.qualifier = m.group(5);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public GraphBundle(String name, TransferableGraph1 data, String id, String version) throws RuntimeBindingException {
        Matcher m = ID_PATTERN.matcher(id);
        if (!m.matches()) {
            throw new IllegalArgumentException("Illegal Id, got \"" + id + "\"");
        }
        m = VERSION_PATTERN.matcher(version);
        if (!m.matches()) {
            throw new IllegalArgumentException("Illegal Version, got \"" + id + "\", <id>/<major.minor.micro.qualifier> is expected.");
        }
        try {
            Binding binding = Bindings.getBindingUnchecked(TransferableGraph1.class);
            this.name = name;
            this.graph = data;
            this.hashcode = binding.hashValue((Object)data);
            this.id = id;
            this.major = Integer.valueOf(m.group(1));
            this.minor = Integer.valueOf(m.group(2));
            this.service = Integer.valueOf(m.group(3));
            if (m.group(4) != null) {
                this.qualifier = m.group(4);
            }
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(GraphBundle o) {
        int cur = this.id.compareTo(o.id);
        if (cur != 0) {
            return cur;
        }
        cur = this.major - o.major;
        if (cur != 0) {
            return cur;
        }
        cur = this.minor - o.minor;
        if (cur != 0) {
            return cur;
        }
        cur = this.service - o.service;
        return cur;
    }

    public TransferableGraph1 getGraph() {
        if (this.graph == null) {
            ReadGraph g = Transaction.readGraph();
            if (g == null) {
                throw new IllegalStateException("No read transaction available");
            }
            try {
                Binding tg_binding = Bindings.getBindingUnchecked(TransferableGraph1.class);
                DatabaseManagementResource DatabaseManagement2 = DatabaseManagementResource.getInstance((ReadGraph)g);
                this.graph = (TransferableGraph1)g.getRelatedValue(this.resource, DatabaseManagement2.HasFile, tg_binding);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
        return this.graph;
    }

    public TransferableGraph1 getGraph(RequestProcessor processor) {
        if (this.graph == null) {
            try {
                this.graph = (TransferableGraph1)processor.syncRequest((Read)new ResourceRead<TransferableGraph1>(this.resource){

                    public TransferableGraph1 perform(ReadGraph graph) throws DatabaseException {
                        Binding tg_binding = Bindings.getBindingUnchecked(TransferableGraph1.class);
                        DatabaseManagementResource DatabaseManagement2 = DatabaseManagementResource.getInstance((ReadGraph)graph);
                        return (TransferableGraph1)graph.getRelatedValue(this.resource, DatabaseManagement2.HasFile, tg_binding);
                    }
                });
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
        return this.graph;
    }

    public int getHashcode() {
        return this.hashcode;
    }

    public int hashCode() {
        return 31 * this.id.hashCode() + 7 * this.major + 3 * this.minor + 11 * this.service + (this.qualifier != null ? 13 * this.qualifier.hashCode() : 0) + this.hashcode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GraphBundle)) {
            return false;
        }
        GraphBundle other = (GraphBundle)obj;
        if (other.hashcode != this.hashcode) {
            return false;
        }
        if (!other.id.equals(this.id)) {
            return false;
        }
        if (other.major != this.major) {
            return false;
        }
        if (other.minor != this.minor) {
            return false;
        }
        if (other.service != this.service) {
            return false;
        }
        return GraphBundle.objectEquals(other.qualifier, this.qualifier);
    }

    static boolean objectEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public boolean getImmutable() {
        return this.immutable;
    }

    public String getId() {
        return this.id;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getService() {
        return this.service;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getVersionedId() {
        return String.valueOf(this.id) + "/" + this.major + "." + this.minor + "." + this.service + "." + this.qualifier;
    }

    public String toString() {
        return String.valueOf(this.name) + ", " + this.id + "/" + this.getVersionedId() + ", hash=" + this.hashcode;
    }

    public long[] getResourceArray() {
        return this.resourceArray;
    }

    public void setResourceArray(long[] resourceArray) {
        this.resourceArray = resourceArray;
    }

    public static void main(String[] args) {
        Matcher m = VERSIONED_ID_PATTERN.matcher("org.simantics.layer0/1.1.1.qualifier");
        if (m.matches()) {
            System.out.println(m.groupCount());
        }
        if ((m = VERSIONED_ID_PATTERN.matcher("org.simantics.layer0/1.1.1")).matches()) {
            System.out.println(m.groupCount());
        }
        if ((m = VERSIONED_ID_PATTERN.matcher("org.simantics.layer0/1.1.1.200810101010")).matches()) {
            System.out.println(m.groupCount());
        }
        if ((m = VERSIONED_ID_PATTERN.matcher("org.simantics.layer0/1.1")).matches()) {
            System.out.println(m.groupCount());
        }
    }
}

