/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.structure;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.simantics.sysdyn.ui.structure.Dependencies;
import org.simantics.sysdyn.ui.structure.Loops;
import org.simantics.sysdyn.ui.structure.ModuleStructure;
import org.simantics.sysdyn.ui.structure.StructureTabItem;

public class StructureView
extends ViewPart {
    private CTabFolder tabFolder;
    private ISelectionListener selectionListener;
    private StructureTabItem dependencies;
    private ModuleStructure moduleStructure;
    private Loops loops;

    public void createPartControl(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tabFolder);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.tabFolder);
        final ISelection currentSeletion = this.getSite().getWorkbenchWindow().getSelectionService().getSelection();
        this.dependencies = new Dependencies(this.tabFolder, 0);
        this.dependencies.drawSelection(currentSeletion);
        this.moduleStructure = new ModuleStructure(this.tabFolder, 0);
        this.loops = new Loops(this.tabFolder, 0);
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                StructureView.this.drawSelection(selection);
            }
        };
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.selectionListener);
        this.tabFolder.addSelectionListener(new SelectionListener(){
            private boolean openedOnce = false;

            public void widgetSelected(SelectionEvent e) {
                if (!this.openedOnce && e.item.equals((Object)StructureView.this.moduleStructure)) {
                    this.openedOnce = true;
                    StructureView.this.moduleStructure.drawSelection(currentSeletion);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tabFolder.addSelectionListener(new SelectionListener(){
            private boolean openedOnce = false;

            public void widgetSelected(SelectionEvent e) {
                if (!this.openedOnce && e.item.equals((Object)StructureView.this.loops)) {
                    this.openedOnce = true;
                    StructureView.this.loops.drawSelection(currentSeletion);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void drawSelection(ISelection selection) {
        this.dependencies.drawSelection(selection);
        this.moduleStructure.drawSelection(selection);
        this.loops.drawSelection(selection);
    }

    public void setFocus() {
        if (this.tabFolder != null && !this.tabFolder.isDisposed()) {
            this.tabFolder.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.selectionListener);
    }
}

